/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.dirtree.filelist;

import javax.swing.*;


/**
 * Specialized for JIBS view FileList
 */

public class FileListSelectionModel extends DefaultListSelectionModel
{
	private boolean myMouseAlwaysAdds = false;
	
	/**
	 * Default is false.
	 * Set to true for the thumbnail display.
	 */
	public void setMouseAlwaysAdds(boolean mouseAdds)
	{
		this.myMouseAlwaysAdds = mouseAdds;
	}
	
	@Override
	public void setSelectionInterval(int index0, int index1)
	{
		if (this.myMouseAlwaysAdds)
		{
			super.addSelectionInterval(index0, index1);
		}
		else
		{
			if (index0 == index1)
			{
				// Nothing is select if it's just the current item.
				// Part of getting rid of bouncing selection indicator in File List
				super.clearSelection();
			}
			else
			{
				super.setSelectionInterval(index0, index1);
			}
		}
	}
}

