/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.lib.dirtree.filelist.popup;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.*;
import java.util.prefs.Preferences;

import javax.swing.*;

import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.util.startup.AppStarter;

/**
 *
 * @author  Gerhard Beck
 */
public class FileNameChangeCompleteTab
   extends JPanel
{
  	Preferences myPrefs;
	private final String USE_NEW_ENDING = "newEnding"; //$NON-NLS-1$
	private final String ENDING = "ending"; //$NON-NLS-1$
	
   JTextField myTextFld = new JTextField(33);
   JTextField myEndingFld = new JTextField(6);
   String mySampleText = "sample"; //$NON-NLS-1$
   JLabel mySampleLbl = new JLabel("<html><big>&nbsp;</big></html>"); //$NON-NLS-1$
   FileSeveralNameChangeDialog myDialog;
   FileName myFileName;
   JRadioButton myKeepEndingBtn = new JRadioButton(AppStarter.getString("FileNameChangeCompleteTab.2")); //$NON-NLS-1$
   JRadioButton myChangeEndingBtn = new JRadioButton(AppStarter.getString("FileNameChangeCompleteTab.3")); //$NON-NLS-1$
	JButton myOkBtn = new JButton(AppStarter.getString("ok")); //$NON-NLS-1$

   //===========================================================================
   //                              Constructor
   //===========================================================================
   FileNameChangeCompleteTab(FileSeveralNameChangeDialog dialog, String sample, int listLength, String appName)
   {
   	super(new BorderLayout());
   	this.myDialog = dialog;
      this.mySampleText = sample;
   	this.myFileName = new FileName(listLength);
   	
   	this.myPrefs = Preferences.userRoot().node("/" + appName + 
   	"/org/gerhardb/jibs/viewer/FileNameChangeCompleteTab"); //$NON-NLS-1$
   	
      setUpScreen();
      this.mySampleLbl.setText(getNewName(1, this.mySampleText, true));
   }
   
	public JButton getDefaultButton()
	{
		return this.myOkBtn;
	}
   
   public String getNewName(int i, String oldName, boolean html)
   {   
   	String ending = null;
   	if (this.myChangeEndingBtn.isSelected())
   	{
   		ending = this.myEndingFld.getText();
   	}
   	return this.myFileName.getNewName(i, oldName, html, ending);
   }
   
   private void setUpScreen()
   {
   	ButtonGroup bg = new ButtonGroup();
   	bg.add(this.myKeepEndingBtn);
   	bg.add(this.myChangeEndingBtn);
   	
      this.myTextFld.addKeyListener(new KeyAdapter()
      {
         @Override
			public  void 	keyReleased(KeyEvent e)
         {
         	FileNameChangeCompleteTab.this.myFileName.setTemplate(FileNameChangeCompleteTab.this.myTextFld.getText());
         	FileNameChangeCompleteTab.this.mySampleLbl.setText(getNewName(1, FileNameChangeCompleteTab.this.mySampleText, true));
         }
      });
   	
      this.myEndingFld.addKeyListener(new KeyAdapter()
      {
         @Override
			public  void 	keyReleased(KeyEvent e)
         {
         	FileNameChangeCompleteTab.this.mySampleLbl.setText(getNewName(1, FileNameChangeCompleteTab.this.mySampleText, true));
            FileNameChangeCompleteTab.this.myPrefs.put(FileNameChangeCompleteTab.this.ENDING, FileNameChangeCompleteTab.this.myEndingFld.getText());   	
         }
      });

      ActionListener endingListener = new ActionListener()
      {
      	public void actionPerformed(ActionEvent e)
      	{
            FileNameChangeCompleteTab.this.myPrefs.putBoolean(FileNameChangeCompleteTab.this.USE_NEW_ENDING, FileNameChangeCompleteTab.this.myChangeEndingBtn.isSelected());  
         	FileNameChangeCompleteTab.this.mySampleLbl.setText(getNewName(1, FileNameChangeCompleteTab.this.mySampleText, true));
            
            if (FileNameChangeCompleteTab.this.myChangeEndingBtn.isSelected())
            {
            	FileNameChangeCompleteTab.this.myEndingFld.setEnabled(true);
            }
            else
            {
            	FileNameChangeCompleteTab.this.myEndingFld.setEnabled(false);
            }      		
      	}
      };
      this.myChangeEndingBtn.addActionListener(endingListener);
      this.myKeepEndingBtn.addActionListener(endingListener);
      
		this.myOkBtn = new JButton(AppStarter.getString("ok")); //$NON-NLS-1$
		this.myOkBtn.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				ok();
			}
		});
		this.myOkBtn.setMnemonic(KeyEvent.VK_K);

		JButton cancelBtn = new JButton(AppStarter.getString("cancel")); //$NON-NLS-1$
		cancelBtn.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				cancel();
			}
		});
      
		JPanelRows mainPanel = new JPanelRows(FlowLayout.CENTER);
		
      JPanel row = mainPanel.topRow();
      row.add(new JLabel("Change name to" + AppStarter.getString("colon") + " ")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myTextFld);
      
      row = mainPanel.nextRow();
      row.add(new JLabel(AppStarter.getString("FileNameChangeCompleteTab.6"))); //$NON-NLS-1$

      row = mainPanel.nextRow();
      row.add(new JLabel("<html>&nbsp;</html>")); //$NON-NLS-1$
      row.add(this.mySampleLbl);

      row = mainPanel.nextRow(FlowLayout.LEFT);
      row.add(this.myKeepEndingBtn);

      row = mainPanel.nextRow(FlowLayout.LEFT);
      row.add(this.myChangeEndingBtn);
      row.add(this.myEndingFld);
      
      this.myEndingFld.setText(this.myPrefs.get(this.ENDING, null));
      if (this.myPrefs.getBoolean(this.USE_NEW_ENDING, false))
      {
      	this.myChangeEndingBtn.setSelected(true);
      	this.myEndingFld.setEnabled(true);
      }
      else
      {
      	this.myKeepEndingBtn.setSelected(true);
      	this.myEndingFld.setEnabled(false);
      }
      
		JPanel btnPanel = new JPanel(new FlowLayout(FlowLayout.CENTER));
		btnPanel.add(this.myOkBtn);
		btnPanel.add(cancelBtn);

		super.add(mainPanel, BorderLayout.CENTER);
		super.add(btnPanel, BorderLayout.SOUTH);
   }

	void ok()
	{
		this.myDialog.doNameChange();
		this.myDialog.done();
	}

   void cancel()
   {
      this.myTextFld.setText(null);
      this.myDialog.done();
   }  
}
