/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.gerhardb.lib.dirtree.filelist.popup;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

import org.gerhardb.lib.image.ImageChangeUtil;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.util.startup.AppStarter;
import org.gerhardb.lib.dirtree.filelist.*;

/**
 *
 * @author  Gerhard Beck
 */
public class FileNameChangeSingleTab extends JPanel
{
	File myFile;
	JTextField myTextFld = new JTextField(33);
	JLabel myPicture = new JLabel(AppStarter.getString("SingleFileNameChanger.0")); //$NON-NLS-1$
	FileListPlugins myPlugins;
	FileSingleNameChangeDialog myDialog;
	JButton myOkBtn = new JButton(AppStarter.getString("ok")); //$NON-NLS-1$

	FileNameChangeSingleTab(FileSingleNameChangeDialog dialog, File file,
			FileListPlugins plubins)
	{
		super(new BorderLayout());
		this.myDialog = dialog;
		this.myFile = file;
		this.myPlugins = plubins;
		this.myTextFld.setText(this.myFile.getName());
		try
		{
			BufferedImage image = ImageFactory.getImageFactory().makeImage(this.myFile)
					.getImage();
			BufferedImage sized = ImageChangeUtil.fitAspectDown(image, 100, 100);
			ImageIcon imageIcon = new ImageIcon(sized);
			this.myPicture = new JLabel(imageIcon);
			this.myPicture.setSize(100, 100);
			Border raisedbevel = BorderFactory.createRaisedBevelBorder();
			Border loweredbevel = BorderFactory.createLoweredBevelBorder();
			Border compound = BorderFactory.createCompoundBorder(raisedbevel,
					loweredbevel);
			this.myPicture.setBorder(compound);
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}

		layoutDialog();
	}

	public JButton getDefaultButton()
	{
		return this.myOkBtn;
	}

	void ok()
	{
		String newName = this.myTextFld.getText();
		if (newName == null) { return; }

		newName = newName.trim();
		if (newName.length() == 0) { return; }

		String newEnding = FileUtil.getExtension(newName);
		if (newEnding == null)
		{
			String oldEnding = FileUtil.getExtension(this.myFile.getName());
			newName = newName + "." + oldEnding; //$NON-NLS-1$
		}

		File newFile = this.myFile;
		try
		{
			String dir = this.myFile.getParentFile().getCanonicalPath();
			String newPathName = dir + "/" + newName; //$NON-NLS-1$
			newFile = new File(newPathName);
			if (newFile.exists())
			{
            JOptionPane.showMessageDialog(
            		this,
                  "There is already a file named:\n" + newFile.getName(),
                  AppStarter.getString("problem"), //$NON-NLS-1$
                  JOptionPane.ERROR_MESSAGE );				
			}
			else
			{
				this.myDialog.iRenamed = true;
				this.myFile.renameTo(newFile);				
			}
		}
		catch (Exception ex)
		{
			JOptionPane.showInputDialog(this,
					AppStarter.getString("FileList.0") + " " + this.myFile.getName() + ".\n" //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
							+ ex.getMessage(), AppStarter.getString("FileList.6"), //$NON-NLS-1$
					JOptionPane.WARNING_MESSAGE);
			this.myPlugins.reloadScroller();
			this.myPlugins.getScroller().selectFile(this.myFile);
			return;
		}

		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		this.myPlugins.reloadScroller();
		this.myPlugins.getScroller().selectFile(newFile);
		/*
		final File showFile = newFile;
		EventQueue.invokeLater(new Runnable()
		{
			public void run()
			{
				System.out.println(showFile);
				myPlugins.getScroller().selectFile(showFile);
			}
		});
*/
		this.myDialog.done();
	}

	void cancel()
	{
		this.myTextFld.setText(null);
		this.myDialog.done();
	}

	private void layoutDialog()
	{
		this.myOkBtn.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				ok();
			}
		});

		JButton cancelBtn = new JButton(AppStarter.getString("cancel")); //$NON-NLS-1$
		cancelBtn.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				cancel();
			}
		});

		JPanelRows myCenterPanel = new JPanelRows();
		JPanel aRow = myCenterPanel.topRow();

		aRow = myCenterPanel.nextRow();
		aRow.add(new JLabel(
				AppStarter.getString("FileList.1") + AppStarter.getString("colon"))); //$NON-NLS-1$ //$NON-NLS-2$
		aRow.add(this.myTextFld);

		aRow = myCenterPanel.nextRow();
		aRow.add(new JLabel(AppStarter.getString("SingleFileNameChanger.3"))); //$NON-NLS-1$

		aRow = myCenterPanel.nextRow(new FlowLayout(FlowLayout.CENTER));
		aRow.add(this.myOkBtn);
		aRow.add(cancelBtn);

		this.add(this.myPicture, BorderLayout.WEST);
		this.add(myCenterPanel, BorderLayout.CENTER);

		this.myOkBtn.setMnemonic(KeyEvent.VK_K);
	}
}
