/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.lib.dirtree.filelist.popup;

import java.io.File;
import javax.swing.JOptionPane;

import org.gerhardb.lib.dirtree.*;
import org.gerhardb.lib.dirtree.filelist.FileListPlugins;
import org.gerhardb.lib.util.startup.AppStarter;

/**
 *
 * @author  Gerhard Beck
 */
public class FileNameChanger
{
   File[] myInputFileList;
   File[] myOutputFileList;
   boolean iRan = false;
   private boolean iFoundDuplicates = false;
   private boolean iWasCancelled = false;
	private boolean iRenamed = false;

   //===========================================================================
   //                              Constructor
   //===========================================================================
   public FileNameChanger(File[] fileList)
   {
	   this.myInputFileList = fileList;
	   this.myOutputFileList = new File[this.myInputFileList.length];
      for(int i=0; i<this.myInputFileList.length; i++)
      {
    	   this.myOutputFileList[i] = this.myInputFileList[i];
          for(int j=i+1; j<this.myInputFileList.length; j++)
          {
        	  if (  this.myInputFileList[i] !=  null &&
        			  this.myInputFileList[j] != null &&
        			  this.myInputFileList[i].equals(this.myInputFileList[j]))
        	  {
        		  if (!this.iFoundDuplicates)
        		  {
        			  this.iFoundDuplicates = true; 
        			  int picked = JOptionPane.showConfirmDialog(null,
        	    	            AppStarter.getString("FileNameChanger.0"), AppStarter.getString("FileNameChanger.1"), JOptionPane.OK_CANCEL_OPTION); //$NON-NLS-1$ //$NON-NLS-2$
         	    	  if (picked == JOptionPane.CANCEL_OPTION)
         	    	  {
          	    		 this.iWasCancelled = true;
         	    		  return;
         	    	  }
         		  }
    			  this.myInputFileList[j] = null;
        	  }
          }   
      }
   }
   
   public File[] getChangedNames()
   {
	   return this.myOutputFileList;
   }
   
	public boolean renamed()
	{
		return this.iRenamed;
	}
	
   public boolean ran(){return this.iRan;}
   
   public void showDialog(FileListPlugins plugins, 
   		DirectoryTree tree,	
   		boolean bothTabs, boolean showRenameTabAtTop)
   {
	   if (this.iWasCancelled){return;}
	   if (this.myInputFileList.length < 2)
	   {
	   	FileSingleNameChangeDialog dialog = new FileSingleNameChangeDialog(this, plugins, tree, bothTabs, showRenameTabAtTop); 	 
	   	this.iRenamed = dialog.renamed();
	   }
	   else
	   {
	   	FileSeveralNameChangeDialog dialog = new FileSeveralNameChangeDialog(this, plugins, tree, bothTabs, showRenameTabAtTop); 
	   	this.iRenamed = dialog.renamed();
	   }
      /*
      boolean debug = false;
      if(debug)
      {
	      for(int i=0; i<myOutputFileList.length; i++)
	      {
	    	  if (myInputFileList[i] != null)
	    	  {
	    		  System.out.println(myInputFileList[i] + "  --  " + myOutputFileList[i]);
	    	  }
	      }
      }
      */
   }
   
}
