/*
 * Copyright (c) 2010 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.lib.dirtree.rdp;

import java.io.File;

import javax.swing.*;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.dirtree.ExtendedDirectoryTree;


/**
 * 
 */
public interface RDPplugins
{	
	public PathManager getPathManager();
	
	public JFrame getTopFrame();
	public ExtendedDirectoryTree getExtendedDirectoryTree();
	public void showStats(DirectoryTreeNode node, boolean countImageFilesInNodes);
	
	// RDPManager
	public boolean isFullScreen();
	public void setWaitCursor(boolean b);
	
	// MoveManager Items - Scroller kinda things
	public File getCurrentFile(); 
	public void removeCurrentFile(); 
	public void reloadScroller(int scrollBackTo, boolean reloadScroller); 
	public void reloadScroller(); 
	
	// PathManager Items
	public void loadParkAndDeleteNodes();
	public void setTreeDirectory(String dirName);
	public void setCurrentDirectory(String dirName);
	
	public String getDirectoryForParkAndDelete();
	public String getPreference(String dirType, String aDefault);
	public void removePreference(String dirType);
}