/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.dirtree.rdp;

import java.io.File;
import java.io.IOException;

import javax.swing.*;
import org.gerhardb.lib.dirtree.*;
import org.gerhardb.lib.util.startup.AppStarter;

/**
 * Utility performing various actions.
 */
public class TreeManagerRDP extends TreeManager
{
	ListShowTreeCoordinator myCoordinator;
	
	// ==========================================================================
	// Constructor
	// ==========================================================================
	public TreeManagerRDP(ListShowTreeCoordinator coordinator)
	{
		super(
				coordinator.myRDPmanager.myPlugins.getTopFrame(),
				coordinator.myRDPmanager.myPlugins.getExtendedDirectoryTree(), 
				null, 
				coordinator.myBasicOptionsManager.getRememberDirectories());
		this.myCoordinator = coordinator;
		super.myReaderWriter = new DTNReaderWriter(
				this.myCoordinator.myLSTplugins.getAppIDandTargetType(), 
				this.myCoordinator.myLSTplugins.getCountTargetFiles(), 
				PathManager.getStartingJibsFile());
		this.myCoordinator.myRDPmanager.myTreeManager = this;
	}
	
	// ==========================================================================
	// Public
	// ==========================================================================
	public void setDirectory(String dir)
	{
		try
		{
			this.myCoordinator.myRDPmanager.myPlugins.getPathManager().setDirectory(PathManager.DIR_TREE, dir);
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		this.myCoordinator.myRDPmanager.getMoveManager().setUndoOff();
		loadSavedTreeDirectory(dir);
		
	}
	
	/**
	 * Change the directory for the tree.
	 */

	public void setTreeDirectory()
	{
		JFileChooser chooser = new JFileChooser();
		chooser.setDialogTitle(AppStarter.getString("TreeManager.0")); //$NON-NLS-1$
		chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

		String treeDirectoryName = this.myCoordinator.myPathManager.getDirectoryAbsolute(PathManager.DIR_TREE);

		if (treeDirectoryName != null)
		{
			chooser.setCurrentDirectory(new File(treeDirectoryName));
		}

		int returnVal = chooser.showOpenDialog(super.myTopFrame);
		if (returnVal == JFileChooser.APPROVE_OPTION)
		{
			try
			{
				treeDirectoryName = chooser.getSelectedFile().getCanonicalPath();

				if (treeDirectoryName != null)
				{
					setDirectory(treeDirectoryName);
				}
			}
			catch (IOException ex)
			{
				ex.printStackTrace();
			}
		}
	}
}
