/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.image;

import java.io.File;
import ij.*;

class ImageFactoryImageJ implements ImageFactoryPlugin
{
	static String[] clsEndings;
	
	static
	{
		// First two rows are just JPEG
		clsEndings = new String[]{"jpg", "jpeg", "j2k", "j", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				"jif", "jiff", "jp2", "jpe", "jpf", "jpx", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ 
				"tif", "tiff", "dcm", "fits", "pgm", "bmp", "gif"}; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$ //$NON-NLS-8$
	}
	
	/*
	public static boolean okToUse(ClassLoader loader)
	{
		//ClassLoader loader = obj.getClass().getClassLoader();
   	System.out.println(loader.getClass().getName());
   	try
   	{
   		loader.loadClass("ij.ImagePlus"); 	 //$NON-NLS-1$
	   	return true;
   	}
   	catch(Exception ex)
   	{
   		System.out.println("ImageJ Plugin not available");
   	}
    	return false;
	}
	*/
	
	public String[] getEndingsLowercase()
	{
		return clsEndings;
	}

	public boolean canHandle(File aFile)
	{
		boolean goodEnding = false;
		String lowerCaseName = aFile.getName().toLowerCase();
		for(int i=0; i<clsEndings.length; i++)
		{
			if (lowerCaseName.endsWith(clsEndings[i]))
			{
				goodEnding = true;
				break;
			}
		}
		
		if (goodEnding)
		{
			try
			{
				//ImageFormat format = Sanselan.guessFormat(aFile);
				//if (!format.equals(ImageFormat.IMAGE_FORMAT_UNKNOWN))
				{
					return true;
				}
			}
			catch(Exception ex)
			{
				System.out.println("ImageFactoryImageJ.canHandle(): " + ex.getMessage()); //$NON-NLS-1$
			}		
		}
		return false;
	}
	
	 /**
    * @return Returns the image if good, else returns null.
    */
   public IOImage makeImage(File aFile)
   throws Exception
   {
      return new IOImageImageJ(aFile);
   }


   @Override
	public String toString()
   {
   	return "ImageJ"; //$NON-NLS-1$
   }
   
   public static void main(String[] args)
   {
   	/*
   	ImageFormat[] formats = ImageFormat.getAllFormats();
   	for(int i=0; i< formats.length; i++)
   	{
   		System.out.println(formats[i].extension);
   	}
   	*/
   	
		System.out.println("------------------------------------------------------"); //$NON-NLS-1$

		ImageFactoryImageJ factory = new ImageFactoryImageJ();
   	String[] endings = factory.getEndingsLowercase();
   	for(int i=0; i< endings.length; i++)
   	{
   		System.out.println(endings[i]);
   	}
   	new ImageJ();
   	IJ.open("D:/testpics/ez.jpg");	
   }
}