/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.image;

import java.io.File;

import org.apache.sanselan.*;

class ImageFactorySanselan implements ImageFactoryPlugin
{
	static String[] clsEndings;
	
	static
	{
		clsEndings = new String[]
		{"apng", "png", "gif", "tiff", "tif", "bmp", "psd", //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
				"pnm", "pgm", "pbm", "ppm", }; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-4$
		/*
	  	ImageFormat[] formats = ImageFormat.getAllFormats();
   	clsEndings = new String[formats.length + 1];
   	for(int i=0; i< formats.length; i++)
   	{
   		clsEndings[i] = formats[i].extension.toLowerCase();
   		// Slight kludge to get rid of unwanted extension "unknown"
   		// and add short JPEG extension.
   		if ("unknown".equals(clsEndings[i]))
   		{
   			clsEndings[i] = "jpg";
   		}
   	}
   	// Kludge for short ending of tiff
   	clsEndings[formats.length] = "tif";
   	*/
	}
	
	public String[] getEndingsLowercase()
	{
		return clsEndings;
	}

	public boolean canHandle(File aFile)
	{
		boolean goodEnding = false;
		String lowerCaseName = aFile.getName().toLowerCase();
		for(int i=0; i<clsEndings.length; i++)
		{
			if (lowerCaseName.endsWith(clsEndings[i]))
			{
				goodEnding = true;
				break;
			}
		}
		
		if (goodEnding)
		{
			try
			{
				ImageFormat format = Sanselan.guessFormat(aFile);
				if (!format.equals(ImageFormat.IMAGE_FORMAT_UNKNOWN))
				{
					return true;
				}
			}
			catch(Exception ex)
			{
				System.out.println("ImageFactorySanselan.canHandle(): " + ex.getMessage()); //$NON-NLS-1$
			}		
		}
		return false;
	}
	
	 /**
    * @return Returns the image if good, else returns null.
    */
   public IOImage makeImage(File aFile)
   throws Exception
   {
      return new IOImageSanselan(aFile);
   }

   public static void main(String[] args)
   {
   	ImageFormat[] formats = ImageFormat.getAllFormats();
   	for(int i=0; i< formats.length; i++)
   	{
   		System.out.println(formats[i].extension);
   	}
   	
		System.out.println("------------------------------------------------------"); //$NON-NLS-1$

		ImageFactorySanselan factory = new ImageFactorySanselan();
   	String[] endings = factory.getEndingsLowercase();
   	for(int i=0; i< endings.length; i++)
   	{
   		System.out.println(endings[i]);
   	}
   	
   }

   @Override
	public String toString()
   {
   	return "Sanselan"; //$NON-NLS-1$
   }
   

}