/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.io;

import java.io.File;

import javax.swing.DefaultListModel;
import javax.swing.JLabel;

/**
 * Model for creating list which just hold directories.
 */
public class DirListModel
   extends DefaultListModel
{
   private JLabel myStatusBar = new JLabel();

   /*
    =============================================================================
                              Constructor
    =============================================================================
    */
   public DirListModel(JLabel status)
   {
      super();
      if (status != null)
      {
      	this.myStatusBar = status;
      }
   }

   /*
    =============================================================================
                             Public Functions
    =============================================================================
    */

   public File[] getDirArray()
   {
      int dirCount = super.getSize();
      File[] dirArray = new File[dirCount];
      for (int i = 0; i < dirCount; i++)
      {
         dirArray[i] = (File)super.getElementAt(i);
      }
      return dirArray;
   }
   
   /**
    * Ignores anything not a directory.
    */
   public void addDirectory(java.io.File file)
   {
      if (file.isDirectory())
      {
         super.addElement(file);
         this.myStatusBar.setText("Added directory: " + file);
      }
   }


   public void recurseAddDirectory(File parent)
   {
      File[] kids = parent.listFiles();
      if (kids != null)
      {
         for (int i = 0; i < kids.length; i++)
         {
            if (kids[i].isDirectory())
            {
               // Show kids before parents!
            	recurseAddDirectory(kids[i]);
               super.addElement(kids[i]);
               this.myStatusBar.setText("Added directory: " +  kids[i]);
            }
         }
      }
   }

   public void justAddKids(File parent)
   {
      File[] kids = parent.listFiles();
      if (kids != null)
      {
         for (int i = 0; i < kids.length; i++)
         {
            if (kids[i].isDirectory())
            {
               super.addElement(kids[i]);
               this.myStatusBar.setText("Added directory: " +  kids[i]);
            }
         }
      }
   }

   @Override
	public void add(int index, Object obj)
   {
      if (obj != null && obj instanceof File && ((File)obj).isDirectory())
      {
         super.add(index, obj);
         this.myStatusBar.setText("Added directory: " + obj);
      }
   }

   @Override
	public void addElement(Object obj)
   {
      if (obj != null && obj instanceof File && ((File)obj).isDirectory())
      {
         super.addElement(obj);
         this.myStatusBar.setText("Added directory: " + obj);
      }
   }

}
