/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.lib.io;

import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

import javax.swing.JFileChooser;

/**
 */
public class DirectoriesOnlyFileFilter
   implements FileFilter
{
   public static final DirectoriesOnlyFileFilter DIRECTORIES_ONLY = new DirectoriesOnlyFileFilter();

   public boolean accept(File file)
   {
      if (file.isDirectory())
      {
         return true;
      }
		return false;
   }

   public static String lookupDir(String msg, String priorDirectory, Component onTopOf)
   {
      JFileChooser chooser = new JFileChooser();
      chooser.setDialogTitle(msg);
      chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
      chooser.setCurrentDirectory(new File(priorDirectory));

      int returnVal = chooser.showOpenDialog(onTopOf);
      if (returnVal == JFileChooser.APPROVE_OPTION)
      {
         try
         {
            return chooser.getSelectedFile().getCanonicalPath();
         }
         catch (IOException ex)
         {
            ex.printStackTrace();
         }
      }
      return null;
   } 
   
} 
