/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.io;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.gerhardb.lib.util.startup.AppStarter;

/**
 *
 */
public class EzLogger
{
   private static final String FILE_DATE_FORMAT = "yyyy.MM.dd-HH.mm.ss"; //$NON-NLS-1$
   private static final SimpleDateFormat FILE_DATE =
      new SimpleDateFormat(FILE_DATE_FORMAT);
   
   public static String NEW_LINE = System.getProperty("line.separator");
   
   FileWriter myFileWriter;
   String newLine = System.getProperty("line.separator"); //$NON-NLS-1$

   public static final String DIVIDER =
      "=====================================" //$NON-NLS-1$
      + "======================================================"; //$NON-NLS-1$

   public static EzLogger makeEzLogger(File dir)
   throws Exception
   {
      String date = FILE_DATE.format(new Date());      
      String logFileName =
      	dir
         + System.getProperty("file.separator") + "jibsLog_" 
         + date + ".txt"; //$NON-NLS-1$
      File logFile = new File(logFileName);
      return new EzLogger(logFile);
   }
   
   /**
    * Writes stuff to a log file.
    * @param fileName
    */
   public EzLogger(File logFile)
   throws Exception
   {
      this.myFileWriter = new FileWriter(logFile);
      System.out.println(AppStarter.getString("EzLogger.3") + AppStarter.getString("colon") + " " + logFile); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

     logLine(AppStarter.getString("EzLogger.4") + AppStarter.getString("colon") + " "); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
     logLine(logFile.toString());
     logLine(AppStarter.getString("EzLogger.5") + AppStarter.getString("colon") + " " + //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
         new SimpleDateFormat().format(new Date()));
     logLine(""); //$NON-NLS-1$
   }

   public void logLine( String entry )
   {
      try
      {
         this.myFileWriter.write(entry + this.newLine);
         this.myFileWriter.flush();
      }
      catch( Exception ex )
      {
         ex.printStackTrace();
      }
   }

   public void logTime( String type, Date start, Date stop )
   {
      final long SECOND = 1000;
      final long MINUTE = 60 * SECOND;

      long elapsed = stop.getTime() - start.getTime();
      logLine( type + " " + AppStarter.getString("EzLogger.7") + AppStarter.getString("colon") + " " + elapsed + " " + AppStarter.getString("EzLogger.8") + " "  ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
      long minutes =  elapsed / MINUTE;
      long minuteRemainder = elapsed % MINUTE;
      long seconds =  minuteRemainder / SECOND;
      long milli = minuteRemainder % SECOND;
      logLine( type + " " + AppStarter.getString("EzLogger.9") + AppStarter.getString("colon") + " " + minutes + " " + AppStarter.getString("EzLogger.10") + " " //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$ //$NON-NLS-7$
         + seconds + " " + AppStarter.getString("EzLogger.11") + " " +  milli + " " +  AppStarter.getString("EzLogger.12") + " " ); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
   }

   public void close()
      throws IOException
   {
      this.myFileWriter.close();
   }

}
