/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.io;

import java.io.File;
import javax.swing.*;

import javax.swing.JOptionPane;

import org.gerhardb.lib.util.startup.AppStarter;

public class FileSaveAs
{
	public static boolean PossibleDuplicateNameOK(File newFile, JFrame frame)
	{
		if (newFile.exists())
		{
			String msg = newFile.getName() + AppStarter.getString("FileSaveAs.0"); //$NON-NLS-1$
			JOptionPane pane = new JOptionPane(msg, JOptionPane.QUESTION_MESSAGE,
					JOptionPane.YES_NO_OPTION);
			String[] options =
			{
					AppStarter.getString("FileSaveAs.1"), AppStarter.getString("FileSaveAs.2") //$NON-NLS-1$ //$NON-NLS-2$
			};
			pane.setOptions(options);
			pane.setInitialSelectionValue(options[1]);
			pane.setInitialValue(options[1]);
			JDialog dialog = pane.createDialog(frame, AppStarter.getString("FileSaveAs.3")); //$NON-NLS-1$
			dialog.setVisible(true);
			Object selectedValue = pane.getValue();
			if (selectedValue == null){ return false;}
			if (options[0].equals(selectedValue))
			{
				// Save picked.
				return true;
			}
			return false;
		}
		return true;

	}
}
