/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.lib.io;

import java.io.*;


/**
 */
public class IOUtils
{

	/**
	 * Finds highest valid directory below root.
	 * If root is highest valid directory, returns passed in value.
	 * @param dir
	 * @return
	 */
   public static File validDirectory(File dir)
   {
   	return new File(validDirectory(dir.getAbsolutePath()));
   }
   
	/**
	 * Finds highest valid directory below root.
	 * If root is highest valid directory, returns passed in value.
	 * @param dir
	 * @return
	 */
   public static String validDirectory(String dir)
   {
   	if (dir == null){return null;}
   	File testDir = new File(dir);
   	if (testDir.exists())
   	{
      	return dir;   		
   	}

		dir = dir.replace('\\', '/');
		String[] pathParts = dir.split("/");

		/*
		for(int i=0; i<pathParts.length; i++)
		{
			System.out.println(i + ": " + pathParts[i]);
		}
		*/
		
		// Forget path we just checked above.
   	int pathToCheck = pathParts.length - 1;
   	// Don't bother if root.  Let it default to user directory.
   	while (pathToCheck > 1)
   	{
   		StringBuffer buff = new StringBuffer(100);
   		for(int i=0; i<pathToCheck; i++)
   		{
   			buff.append(pathParts[i]);
   			buff.append("/");
   		}
   	  	testDir = new File(buff.toString());
			//System.out.println(testDir);
      	if (testDir.exists())
      	{
         	return testDir.getAbsolutePath();   		
      	}
   		pathToCheck--;
   	}
   	return dir;
   } 
   
   public static void main(String[] args)
   {
   	System.out.println(validDirectory("======================================="));
   	System.out.println(validDirectory("These return themselves from short circuit"));
   	System.out.println(validDirectory("D:/dev/workspaces/JIBS/web"));
   	System.out.println(validDirectory("D:"));
   	System.out.println(validDirectory("======================================="));
   	System.out.println(validDirectory("These return themselves from not returning root exception"));
   	System.out.println(validDirectory("D:/xxx"));
    	System.out.println(validDirectory("D:/xxx/yyy"));
   	System.out.println(validDirectory("D:/xxx/yyy/zzz"));
   	System.out.println(validDirectory("======================================="));
   	System.out.println(validDirectory("These return highest valid directory"));
   	System.out.println(validDirectory("D:/dev/xxx/yyy/zzz"));
   	System.out.println(validDirectory("D:/dev/workspaces/xxx/yyy/zzz"));
   	System.out.println(validDirectory("D:/dev/workspaces/JIBS/xxx/yyy/zzz"));
   	System.out.println(validDirectory("D:/dev/workspaces/JIBS/web/xxx/yyy/zzz"));
   }
   
} 
