/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.print;

import java.awt.Color;


/**
 * 
 */
public class HeaderFooterInfo
{ 
	public static final String PAGE_INDEX = "<#>"; //$NON-NLS-1$
	public static final String PAGE_COUNT = "<##>"; //$NON-NLS-1$
	public static final String DEFAULT_FOOTER = PAGE_INDEX + " of " + PAGE_COUNT; //$NON-NLS-1$ 
	public static final String JIBS_WEB_SITE = "www.jibs.us"; //$NON-NLS-1$
	public static final String PRINTED_BY_JIBS = "Printed By JIBS"; //$NON-NLS-1$

	public String headerLeft;
	public String headerCenter;
	public String headerRight;	
	
	public String footerLeft = JIBS_WEB_SITE;
	public String footerCenter = DEFAULT_FOOTER;
	public String footerRight = PRINTED_BY_JIBS;	
	
	public int headerFontSize = 12;
	public int footerFontSize = 12;
	public String headerFontFamily = "SansSerif";
	public String footerFontFamily = "SansSerif";
	public boolean showLines = true;
	public Color textColor = Color.BLACK;
	//public Color backgroundColor = Color.WHITE;
	
	public HeaderFooterInfo makePageCountAdjusted(int pageIndex, Convertible c)
	{
		HeaderFooterInfo rtnMe = new HeaderFooterInfo();
		
		rtnMe.headerLeft = c.convert(this.headerLeft, pageIndex); 
	   rtnMe.headerCenter = c.convert(this.headerCenter, pageIndex);
		rtnMe.headerRight = c.convert(this.headerRight, pageIndex);	
		
		rtnMe.footerLeft = c.convert(this.footerLeft, pageIndex);
		rtnMe.footerCenter = c.convert(this.footerCenter, pageIndex);
		rtnMe.footerRight = c.convert(this.footerRight, pageIndex);	
		
		rtnMe.headerFontSize = this.headerFontSize;
		rtnMe.footerFontSize = this.footerFontSize;
		rtnMe.headerFontFamily = this.headerFontFamily;
		rtnMe.footerFontFamily = this.footerFontFamily;
		rtnMe.showLines = this.showLines;
		rtnMe.textColor = this.textColor;
		
		// Header and Footer is assumed to have same background as margin.
		//rtnMe.backgroundColor = this.backgroundColor;
		
		return rtnMe;
	}
}
