/*
 * Copyright (c) 2011 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.print;

import java.awt.*;

import javax.swing.JFrame;
import javax.swing.JProgressBar;


/**
 * Easier to user replacement for java.Pageable.
 * Not really, but it servers the same purpose in this framework.
 */
public interface Pageable extends Convertible
{
	public void setTopFrame(JFrame topFrame);
	
	/**
	 * Whole document will have only one page layout.
	 * @return
	 */
	public PageLayout getPageLayout();
	
	// Used by HeaderFooter for: Page 3 of 16
	public int getNumberOfPages();
	
	// Because gnuJpdf only works with internal fonts.
	// Used to turn off gnuJpdf button.
	public String[] getFonts();
	
	// Used by Save button to find out where to save.
	public SaveInfo getSaveInfo();
	
	/**
	 * 
	 * @return true if images will be retrieved on a background thread.  False if not.
	 * Effectively means you need to decide when you create the pageable if its to screen or printer.
	 */
	public boolean backgroundTreadEnabled();
	
	/**
	 * Prepares pagable for printing.  For example, by starting thread to get images for printing.
	 * @param pageIndex - Actual page shown.  So first page would be 1.  Last page will equal getNumberOfPages().
	 * 		So the following would be valid to print the last page: print(g2, pl, getNumberOfPages());
	 * @param backgroundThread - Process preparation on background thread.  If false, all images will be fetched before this returns.
	 * If true, paint can be called any number of times while background thread loads things up.
	 */
	public void prepareToPrint(int pageIndex);
	
	/**
	 * Print using page index set up by prepareToPrint().
	 * @param g2 - Graphics to paint with.
	 */
	public void print(Graphics g);
	
	public void setProgressBar(JProgressBar bar);
	
	/**
	 * Return a copy for printing separately from one used for preview.
	 * @return
	 */
	public Pageable getPageableForPrinting();
}
