/*
 * Copyright (c) 2011 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.print;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;

import javax.swing.*;


/**
 * Static methods.
 */
public class PageableUtils
{
	public static final int PREVIEW = 0;
	public static final int PRINT = 1;
	public static final int SAVE_JPG = 2;
	public static final int SAVE_PDF = 3;
	
   static final DecimalFormat FILE_COUNT_FORMAT = new DecimalFormat("#0000"); //$NON-NLS-1$
 
   public static void saveAsJpg(Pageable pageable, JFrame frame, final JProgressBar bar)
   {
		bar.setMaximum(pageable.getNumberOfPages());    
		bar.setValue(0);  	
      PropertyChangeListener listener = new PropertyChangeListener()
   	{
   		public void propertyChange(PropertyChangeEvent evt)
   		{
   			{
               if ("progress".equals(evt.getPropertyName())) 
               {
               	bar.setValue(((Integer)evt.getNewValue()).intValue());
               }
   			}
   		}
   	};   	   	
		SaveAsJpgWorker worker = new SaveAsJpgWorker(pageable, frame);
   	worker.addPropertyChangeListener(listener);
   	worker.execute();
   }
    
	public static void printToPrinter(Pageable pageable, JFrame frame, final JProgressBar bar)
	{
		bar.setMaximum(pageable.getNumberOfPages());  
		bar.setValue(0);  	    	
      PropertyChangeListener listener = new PropertyChangeListener()
   	{
   		public void propertyChange(PropertyChangeEvent evt)
   		{
   			{
               if ("progress".equals(evt.getPropertyName())) 
               {
               	bar.setValue(((Integer)evt.getNewValue()).intValue());
               }
   			}
   		}
   	};   	   	
   	PrintToPrinterWorker worker = new PrintToPrinterWorker(pageable, frame);
   	worker.addPropertyChangeListener(listener);
   	worker.execute();
	}
}

