/*
 * Copyright (c) 2011 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.print;

import java.awt.*;

import javax.swing.*;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.swing.GlassPane;

/**
 * Static methods.
 */
public class PrintToPrinterWorker extends SwingWorker<Object, Object>
	{
 		Pageable pageable;
 		JFrame frame;
 		GlassPane eatMe = new GlassPane();
 		
 		PrintToPrinterWorker(Pageable pageableIn, JFrame frameIn)
 		{
 			this.pageable = pageableIn;
 			this.frame = frameIn;
 			
 			this.frame.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR)); 			
 			this.eatMe.setGlassPane(this.frame);
 		}
 		
 		@Override
 		protected void done()
 		{	
 			this.frame.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
 			this.eatMe.removeGlassPane(); 			
 		}
 		
		@Override
		protected Object doInBackground() throws Exception
		{
			try
			{
				JobAttributes jobAttributes = new JobAttributes();
				Toolkit toolkit = Toolkit.getDefaultToolkit();
				PrintJob pjob = toolkit.getPrintJob(this.frame, "JIBS Printing",
						jobAttributes, null);
				if (pjob != null)
				{
					int pageCount = this.pageable.getNumberOfPages();
					for(int i=1; i <= pageCount; i++)
					{
						Graphics printGraphics = pjob.getGraphics();	
						
						// This results in really crappy low resolutio printing.
						//this.myPreviewPanel.drawPage(printGraphics, i);
						
						// This works great, but you can only use a graphics,
						// not a Graphics2D
						this.pageable.prepareToPrint(i);
						this.pageable.print(printGraphics);
						
						printGraphics.dispose();	
						super.setProgress(i);
					}
					pjob.end();
				}
				else
				{
					System.err.println("Can't print: printjob null");
				}		}
			catch(Exception ex)
			{
				ex.printStackTrace();
	            JOptionPane.showMessageDialog(
	            		this.frame,
	                ex.getMessage(),
	                Jibs.getString("problem"), //$NON-NLS-1$
	                JOptionPane.ERROR_MESSAGE );  
	            return null;
			}  
			return null;
		}   		
	}
 	