/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.print.contactSheet;

import java.awt.Color;

/**
 * ContactSheetOptions, the Interface
 */
public class ContactSheetInfo
{

	public enum ResizeDPI
	{
		DPI_ALL("Store full image in PDF", 0), 
		DPI_600("600 DPI", 600), 
		DPI_300("300 DPI", 300), 
		DPI_150("150 DPI", 150), 
		DPI_72("72 DPI", 72);

		private final String label;
		private final int dpi;

		ResizeDPI(String s, int dpiIn)
		{
			this.label = s;
			this.dpi = dpiIn;
		}

		@Override
		public String toString()
		{
			return this.label;
		} 
		
		public int dpi()
		{
			return this.dpi;
		}
		
		public static ResizeDPI fromString(String text)
		{
			if (text != null)
			{
				for (ResizeDPI b : ResizeDPI.values())
				{
					if (text.equalsIgnoreCase(b.label)) { return b; }
				}
			}
			return null;
		}
	}
	
	public enum ResizeType
	{
		EXSHARP("Extra Sharp"), // Not Yet Coded -- Swiss
		SHARP("Sharp"), // FilthyRichClientsUtils
		FUZY("Soft"); // ImageJ

		private final String label;

		ResizeType(String s)
		{
			this.label = s;
		}

		@Override
		public String toString()
		{
			return this.label;
		} 
		
		public static ResizeType fromString(String text)
		{
			if (text != null)
			{
				for (ResizeType b : ResizeType.values())
				{
					if (text.equalsIgnoreCase(b.label)) { return b; }
				}
			}
			return null;
		}
	}
		
	// Pictures Tab
	public int rows = 4;
	public int cols = 3;
	public boolean showPictureName = true;
	public boolean showPictureNumber = false;
	public boolean showPictureSize = false;
	public int frameSize = 1;
	public int shadowSize = 0;
	
	// Fonts Tab
	public int pictureFontSize = 10;
	public String pictureFontFamily = "SansSerif";
	public Color pictureTextColor = Color.BLACK;
	
	// Colors Tab
	public Color backgroundColor = Color.WHITE;
	public Color foregroundColor = Color.BLACK;
	
	public ResizeDPI resizeDPI = ResizeDPI.DPI_300;
	public ResizeType resizeType = ResizeType.EXSHARP;
}
