/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.print.contactSheet;

import java.io.File;
import java.util.Arrays;

import org.gerhardb.jibs.optimizer.NoDirectories;
import org.gerhardb.lib.io.FileNameComparatorInsensative;

/**
 * DirFiles
 */
public class DirFiles
{
	File directory;
	File[] files;
	
	// Page is files divided by pics per page.
	int pageCount;
	
	// When printing, first page prints as index zero.
	// This is used to get the correct base index within a directory by taking
	// the passed in page index across all directories and subtracting this 
	// number.  So if this is the second directory and the first directory had
	// 4 pages, this would be 4.  Then, when the page index of 4 comes in
	// (meaning the fifth page), 4 will be subtracted giving a zero which is
	// the page index within that directory and will result in a "1 of x"
	// being shown to the user.
	int indexOfLastPageBeforeThisDirectory = 0;
	
	DirFiles(File d)
	{
		//System.out.println("DirFiles: " + d);
		this.directory = d;
		this.files = this.directory.listFiles(NoDirectories.NO_DIRECTORIES);		
		try{Arrays.sort(this.files, new FileNameComparatorInsensative());}
		catch(Exception ex){ex.printStackTrace();}
	}
	
	@Override
	public String toString()
	{
		return this.directory.toString() + "\nindexOfLastPageBeforeThisDirectory: " + this.indexOfLastPageBeforeThisDirectory;
	}	
}