/*
 * Copyright (c) 2011 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.print.contactSheet;

import java.io.File;


public abstract class ListToDraw 
{
	public static final String PIC_FIRST_INDEX = "<%!>"; //$NON-NLS-1$
	public static final String PIC_LAST_INDEX = "<%@>"; //$NON-NLS-1$
	public static final String PIC_COUNT = "<%%>"; //$NON-NLS-1$
	public static final String CURRENT_DIRECTORY = "<%DIR%>"; //$NON-NLS-1$
	
	// Count of all the pictures for all directories
	int overallPicCount;
	
	// Number of pictures on a page
	int picsPerPage;
	
	// Compute from overallPicCount and picsPerPage and Directory list
	int pageCount;
	
	abstract public String convert(String text, int pageIndex);
	abstract FilesForPage getFilesForPage(int pageIndex);
	
	public static ListToDraw makeListToDraw(File[] f, int row, int col, 
			boolean showFilesNotDirectories)
	{
		int picsPerPage = row * col;
		if (showFilesNotDirectories)
		{
			return new ListToDrawFiles(f, picsPerPage);
		}
		return new ListToDrawDirectories(f, picsPerPage);	
	}
	
	class FilesForPage
	{
		File[] files;
		int startPicIndex;
		
		protected FilesForPage(){ /* warning supression re synthetic */}
		
		boolean filesToPrint()
		{
			if (this.startPicIndex < this.files.length)
			{
				return true;
			}
			return false;
		}
	}
	
	int calcPages(int fileCount)
	{
		int rtnMe = fileCount / this.picsPerPage;
		int remainder = fileCount % this.picsPerPage;
		if (remainder != 0)
		{
			// Add a page for the stuff at the end.
			rtnMe++;
		}			
		// If there are no pictures, still show at least one page.
		if (rtnMe < 1)
		{
			return 1;
		}		
		return rtnMe;
	}
}