/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.print.contactSheet;

import java.io.File;

import org.gerhardb.lib.util.SoftKeyHashMap;

/**
 * ContactSheet
 */
public class ResizedImageCache
{
	private SoftKeyHashMap map = new SoftKeyHashMap();
	private ResizedImageFactory resizedImageFactory;
	
	public ResizedImageCache(ResizedImageFactory rif)
	{
		this.resizedImageFactory = rif;
	}
	
	public ResizedImage putImage(File imageFile, int drawIndex)
	{
		ResizedImage rtnMe = null;
		synchronized(this)
		{
			rtnMe = (ResizedImage)this.map.get(imageFile);
		}
		if (rtnMe == null)
		{
			rtnMe = this.resizedImageFactory.makeResizedImage(imageFile, drawIndex, false);
			synchronized(this)
			{
				this.map.put(imageFile, rtnMe);
			}
		}
		return rtnMe;
	}
	
	public ResizedImage getImage(File imageFile)
	{
		ResizedImage rtnMe = null;
		synchronized(this)
		{
			rtnMe = (ResizedImage)this.map.get(imageFile);
		}
		return rtnMe;
	}
}















