/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.scroller;

import java.io.File;

import org.gerhardb.lib.image.ImageFactory;

public class FileListFactory
   implements ListMaker
{
   File myDirectory = null;

   public FileListFactory(File aFile)
   {
      this.myDirectory = aFile;
      if (this.myDirectory == null)
      {
         throw new IllegalArgumentException(
            "FilePageFactory requires non-null file/directory."); //$NON-NLS-1$
      }
      if (this.myDirectory.isFile())
      {
         this.myDirectory = this.myDirectory.getParentFile();
      }
   }

   public String getDescription()
   {
      return this.myDirectory.getAbsolutePath();
   }

   public File[] getFileList()
   {
      return this.myDirectory.listFiles(ImageFactory.getImageFactory().getFilter());
   }

}
