/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.scroller;

import java.io.File;

/**
 * Messages not appropriate for other listeners.
 */
public class ScrollerChangeEvent
{	
   /**
    * Indicates that the current image has changes and that the listening
    * software should redisplay the image.
    */
   public static final int CURRENT_IMAGE_CHANGED = 0;

   /**
    * Indicates that the current image has changes and that the listening
    * software should redisplay the image and replay the sounds.
    */
   public static final int CURRENT_PAGE_CHANGED = 1;

   /**
    * Indicates that the list has changed by removing a single file.
    */
   public static final int ONE_FILE_REMOVED = 2;

   /**
    * Indicates that the list has been reloaded from the file system
    */
   public static final int LIST_RELOADED = 3;

   private int myEventType;
	private int myIndexRemoved = -1;
	private File myFile;
	private boolean iReloadCahce;

   public ScrollerChangeEvent(int type, int index)
   {
      if (type < CURRENT_IMAGE_CHANGED || type > LIST_RELOADED)
      {
         throw new IllegalArgumentException("ScrollerChangeEvent bad type"); //$NON-NLS-1$
      }
      this.myEventType = type;
      this.myIndexRemoved = index;
   }
   
   public ScrollerChangeEvent(int type, int index, File file)
   {
      if (type < CURRENT_IMAGE_CHANGED || type > LIST_RELOADED)
      {
         throw new IllegalArgumentException("ScrollerChangeEvent bad type"); //$NON-NLS-1$
      }
      this.myEventType = type;
      this.myIndexRemoved = index;
      this.myFile = file;
   }

  public ScrollerChangeEvent(int type, boolean reloadCache)
   {
      if (type < CURRENT_IMAGE_CHANGED || type > LIST_RELOADED)
      {
         throw new IllegalArgumentException("ScrollerChangeEvent bad type"); //$NON-NLS-1$
      }
      this.myEventType = type;
      this.iReloadCahce = reloadCache;
   }
  
  public boolean getReloadCache()
  {
	  return this.iReloadCahce;
  }

   public File getFile()
   {
   	return this.myFile;
   }
   
   public int getEventType()
   {
      return this.myEventType;
   }

   public int getIndexRemoved()
   {
      return this.myIndexRemoved;
   }
}
