/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.scroller;

import javax.swing.event.ListDataEvent;

/**
 * Messages not appropriate for other listeners.
 */
public class ScrollerListDataEvent extends ListDataEvent
{	
	private boolean iReloadCahce;

   /**
    * Constructs a ListDataEvent object. If index0 is >
    * index1, index0 and index1 will be swapped such that
    * index0 will always be <= index1.
    *
    * @param source  the source Object (typically <code>this</code>)
    * @param type    an int specifying {@link #CONTENTS_CHANGED},
    *                {@link #INTERVAL_ADDED}, or {@link #INTERVAL_REMOVED}
    * @param index0  one end of the new interval
    * @param index1  the other end of the new interval
    */
   public ScrollerListDataEvent(Object theSource, int type, int index0, int index1, boolean reloadCahce) 
   {
       super(theSource, type, index0, index1);
       this.iReloadCahce = reloadCahce;
   }
   
   public boolean reloadCahce()
   {
   	return this.iReloadCahce;
   }
}
