/*
 * Copyright (c) 2011 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.swing;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

/**
 * Design to only allow numbers and periods like: 123.456
 * jTextField1.setDocument(new OnlyFloat());
 * From http://tutopod.com/2011/01/15/filter-character-and-set-only-number-in-jtextfield-j2se/
 * @author Mudafig
 */
public class OnlyFloat extends PlainDocument
{
	@Override
	public void insertString(int offs, String str, AttributeSet a)
			throws BadLocationException
	{
		StringBuffer buffer = new StringBuffer();
		int s = 0;
		char[] dataInput = str.toCharArray();
		for (int i = 0; i < dataInput.length; i++)
		{
			boolean isOnlyDigit = Character.isDigit(dataInput[i]) || dataInput[i] == '.';
			if (isOnlyDigit == true)
			{
				dataInput[s] = dataInput[i];
				s++;
			}
		}
		buffer.append(dataInput, 0, s);
		super.insertString(offs, new String(buffer), a);
	}
}