/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;

import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

/**
 * Creates a UIMenu
 */
public class UIMenu 
{
  	Preferences myPrefs;
	private static final String USER_INTERFACE = "ui"; //$NON-NLS-1$
 	
	int mySelectedUI;
	Component myComponent;
	
	public UIMenu(Component c, String appName)
	{
		this.myComponent = c;
	  	this.myPrefs = Preferences.userRoot().node("/" + appName + "/org/gerhardb/lib/swing/UIMenu"); //$NON-NLS-1$
	}
	
	public JMenu populateUIMenu(JMenu menuUI)
	{
		ButtonGroup lookGroup = new ButtonGroup();
		final UIManager.LookAndFeelInfo[] feels = UIManager
				.getInstalledLookAndFeels();
		final JRadioButtonMenuItem[] menuItems = new JRadioButtonMenuItem[feels.length];
		for (int i = 0; i < feels.length; i++)
		{
			menuItems[i] = makeUIMenuItem(feels[i], i);
			menuUI.add(menuItems[i]);
			lookGroup.add(menuItems[i]);
			// PRINT OUT WHAT IS AVAILABLE
			//System.out.println("LookAndFeel.getName: " + feels[i].getName());
			//System.out.println("LookAndFeel.getClassName: " + feels[i].getClassName());
			
		}

		menuUI.addMenuListener(new MenuListener()
		{
			public void menuCanceled(MenuEvent e)
			{
				// We don't care
			}

			public void menuDeselected(MenuEvent e)
			{
				// We don't care
			}

			public void menuSelected(MenuEvent e)
			{
				menuItems[UIMenu.this.mySelectedUI].setSelected(true);
			}
		});

		return menuUI;
	}
	
	public void initLookAndFeel()
	{
		final UIManager.LookAndFeelInfo[] feels = UIManager
				.getInstalledLookAndFeels();
		String ui = this.myPrefs.get(USER_INTERFACE, null);
		for (int i = 0; i < feels.length; i++)
		{
			if ( ui != null && ui.equals(feels[i].getClassName()))
			{
				try
				{
					Class<?> x = Class.forName(ui);
					UIManager.setLookAndFeel((LookAndFeel) x.newInstance());				
					SwingUtilities.updateComponentTreeUI(this.myComponent);
				}
				catch(Exception ex)
				{
					ex.printStackTrace();
				}
			}
		}
			
		// See what we actually got.
		LookAndFeel laf = UIManager.getLookAndFeel();
		for (int i = 0; i < feels.length; i++)
		{
			if (laf.getClass().getName().equals(feels[i].getClassName()))
			{
				this.mySelectedUI = i;
			}
		}
	}

	private JRadioButtonMenuItem makeUIMenuItem(
			UIManager.LookAndFeelInfo info, int i)
	{
		final int index = i;
		final UIManager.LookAndFeelInfo myLook = info;
		JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(myLook.getName());
		menuItem.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				try
				{
					String ui = myLook.getClassName();
					Class<?> x = Class.forName(ui);
					UIManager.setLookAndFeel((LookAndFeel) x.newInstance());
					UIMenu.this.mySelectedUI = index;
					UIMenu.this.myPrefs.put(USER_INTERFACE, ui);
					try{UIMenu.this.myPrefs.flush();}catch(Exception ex)
					{
						ex.printStackTrace();
					}				
				}
				catch (Exception e)
				{
					e.printStackTrace();
				}
				SwingUtilities.updateComponentTreeUI(UIMenu.this.myComponent);
			}
		});
		return menuItem;
	}
}