/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.lib.util;

import java.text.DecimalFormat;

public class Conversions
{
	public static final long SECOND = 1000;
	public static final long MINUTE = SECOND * 60;
	public static final long HOUR = MINUTE * 60;
	public static final long DAY = HOUR * 24;
	public static final long WEEK = DAY * 7;
	
	public static final DecimalFormat FORMAT = new DecimalFormat("0.0"); //$NON-NLS-1$
	public static final long KILOBYTE = 1000;                 // kB
	public static final long MEGABYTE = KILOBYTE * KILOBYTE;  // MB
	public static final long GIGABYTE = MEGABYTE * KILOBYTE;  // GB
	public static final long TERABYTE = GIGABYTE * KILOBYTE;  // TB
	public static final long PETABYTE = TERABYTE * KILOBYTE;  // PB
	
	public static final long KIBIBYTE = 1024;                 // KiB
	public static final long MEBIBYTE = KIBIBYTE * KIBIBYTE;  // MiB
	public static final long GIBIBYTE = MEBIBYTE * KIBIBYTE;  // GiB
	public static final long TEBIBYTE = GIBIBYTE * KIBIBYTE;  // TiB
	public static final long PEBIBYTE = TEBIBYTE * KIBIBYTE;  // PiB
	// Need something bigger to deal with these.
	//public static final long EXBIBYTE = PEBIBYTE * KIBIBYTE;  // EiB
	//public static final long ZEBIBYTE = EXBIBYTE * KIBIBYTE;
	//public static final long YOBIBYTE = ZEBIBYTE * KIBIBYTE;
	
	public static String formattedMetricBytes(long bytes)
	{
      if (bytes >= PETABYTE)
      {
   		return FORMAT.format((float)bytes / (float)PETABYTE) + " PB";	 //$NON-NLS-1$
      }
      else if (bytes >= TERABYTE)
      {
   		return FORMAT.format((float)bytes / (float)TERABYTE) + " TB";	 //$NON-NLS-1$
      }
      else if (bytes >= GIGABYTE)
      {
   		return FORMAT.format((float)bytes / (float)GIGABYTE) + " GB";	 //$NON-NLS-1$
      }
      else if (bytes >= MEGABYTE)
      {
   		return FORMAT.format((float)bytes / (float)MEGABYTE) + " MB";	 //$NON-NLS-1$
      }
      else if (bytes >= KILOBYTE)
      {
   		return FORMAT.format((float)bytes / (float)KILOBYTE) + " kB";	 //$NON-NLS-1$
      }
      else
      {
   		return bytes + " btyes";	 //$NON-NLS-1$
      }
	}
	
	public static String formattedBinaryBytes(long bytes)
	{
		// Using binary its 
		// KiB, MiB, GiB, TiB, PiB, EiB, ZiB, YiB
      if (bytes >= PEBIBYTE)
      {
   		return FORMAT.format((float)bytes / (float)PEBIBYTE) + " PiB";	 //$NON-NLS-1$
      }
      else if (bytes >= TEBIBYTE)
      {
   		return FORMAT.format((float)bytes / (float)TEBIBYTE) + " TiB";	 //$NON-NLS-1$
      }
      else if (bytes >= GIBIBYTE)
      {
   		return FORMAT.format((float)bytes / (float)GIBIBYTE) + " GiB";	 //$NON-NLS-1$
      }
      else if (bytes >= MEBIBYTE)
      {
   		return FORMAT.format((float)bytes / (float)MEBIBYTE) + " MiB";	 //$NON-NLS-1$
      }
      else if (bytes >= KIBIBYTE)
      {
   		return FORMAT.format((float)bytes / (float)KIBIBYTE) + " KiB";	 //$NON-NLS-1$
      }
      else
      {
   		return bytes + " btyes";	 //$NON-NLS-1$
      }
	}
	
	public static void main(String[] args)
	{
		System.out.println("KIBIBYTE: " + formattedBinaryBytes(KIBIBYTE) + "   " + KIBIBYTE); //$NON-NLS-1$ //$NON-NLS-2$
		System.out.println("MEBIBYTE: " + formattedBinaryBytes(MEBIBYTE) + "   " + MEBIBYTE); //$NON-NLS-1$ //$NON-NLS-2$
		System.out.println("GIBIBYTE: " + formattedBinaryBytes(GIBIBYTE) + "   " + GIBIBYTE); //$NON-NLS-1$ //$NON-NLS-2$
		System.out.println("TEBIBYTE: " + formattedBinaryBytes(TEBIBYTE) + "   " + TEBIBYTE); //$NON-NLS-1$ //$NON-NLS-2$
		System.out.println("PEBIBYTE: " + formattedBinaryBytes(PEBIBYTE) + "   " + PEBIBYTE); //$NON-NLS-1$ //$NON-NLS-2$
		//System.out.println("EXBIBYTE: " + formattedBinaryBytes(EXBIBYTE) + "   " + EXBIBYTE);
		//System.out.println("ZEBIBYTE: " + formattedBinaryBytes(ZEBIBYTE) + "   " + ZEBIBYTE);
		//System.out.println("YOBIBYTE: " + formattedBinaryBytes(YOBIBYTE) + "   " + YOBIBYTE);
		
		System.out.println("???: " + formattedBinaryBytes(800) + "   " + 800); //$NON-NLS-1$ //$NON-NLS-2$
		System.out.println("???: " + formattedBinaryBytes(1000) + "   " + 1000); //$NON-NLS-1$ //$NON-NLS-2$
		System.out.println("???: " + formattedBinaryBytes(1023) + "   " + 1023); //$NON-NLS-1$ //$NON-NLS-2$
		
		System.out.println("???: " + formattedBinaryBytes(1025) + "   " + 1025); //$NON-NLS-1$ //$NON-NLS-2$
		System.out.println("???: " + formattedBinaryBytes(1900) + "   " + 1900); //$NON-NLS-1$ //$NON-NLS-2$
		System.out.println("???: " + formattedBinaryBytes(2048) + "   " + 2048); //$NON-NLS-1$ //$NON-NLS-2$
		
		long amt = (long)(MEBIBYTE * .89f);
		System.out.println("???: " + formattedBinaryBytes(amt) + "   " + amt); //$NON-NLS-1$ //$NON-NLS-2$
		amt = (long)(MEBIBYTE * .91f);
		System.out.println("???: " + formattedBinaryBytes(amt) + "   " + amt); //$NON-NLS-1$ //$NON-NLS-2$
		amt = (long)((float)MEBIBYTE * 15);
		System.out.println("???: " + formattedBinaryBytes(amt) + "   " + amt); //$NON-NLS-1$ //$NON-NLS-2$
		amt = (long)(MEBIBYTE * 15.9f);
		System.out.println("???: " + formattedBinaryBytes(amt) + "   " + amt); //$NON-NLS-1$ //$NON-NLS-2$
		amt = MEBIBYTE * 16;
		System.out.println("???: " + formattedBinaryBytes(amt) + "   " + amt); //$NON-NLS-1$ //$NON-NLS-2$
		amt = (long)(MEBIBYTE * 16.2);
		System.out.println("???: " + formattedBinaryBytes(amt) + "   " + amt); //$NON-NLS-1$ //$NON-NLS-2$
		
		amt = (long)(GIBIBYTE * 16.2);
		System.out.println("???: " + formattedBinaryBytes(amt) + "   " + amt); //$NON-NLS-1$ //$NON-NLS-2$
		amt = (long)(TEBIBYTE * 16.2);
		System.out.println("???: " + formattedBinaryBytes(amt) + "   " + amt); //$NON-NLS-1$ //$NON-NLS-2$
		amt = (long)(PEBIBYTE * 16.2);
		System.out.println("???: " + formattedBinaryBytes(amt) + "   " + amt); //$NON-NLS-1$ //$NON-NLS-2$
		
		/*
		System.out.println("1023b: " + formattedBinaryBytes(1023));
		System.out.println("1k: " + formattedBinaryBytes(1024));
		System.out.println("1k ---: " + formattedBinaryBytes(1025));
		System.out.println("5.5k: " + formattedBinaryBytes((long)(KILOBYTE * 5.5)));
		long showMe = KILOBYTE;
		showMe = showMe * KILOBYTE;
		System.out.println("1023k: " + formattedBinaryBytes(showMe - 1));
		System.out.println("1m: " + formattedBinaryBytes(showMe));
		System.out.println("1m: " + formattedBinaryBytes(showMe + 1));
		showMe = showMe * KILOBYTE;
		System.out.println("1023m: " + formattedBinaryBytes(showMe - 1));
		System.out.println("1g: " + formattedBinaryBytes(showMe));
		showMe = showMe * KILOBYTE;
		System.out.println("1023g: " + formattedBinaryBytes(showMe - 1));
		System.out.println("1t: " + formattedBinaryBytes(showMe));
		showMe = showMe * KILOBYTE;
		System.out.println("1023t: " + formattedBinaryBytes(showMe - 1));
		System.out.println("1p: " + formattedBinaryBytes(showMe));
		*/
	}
}
