/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;

import javax.swing.ImageIcon;

import org.gerhardb.lib.image.ImageUtil;

/**
 * See what they look like:
 * http://java.sun.com/developer/techDocs/hi/repository/
 *
 * Instructions:
 * http://java.sun.com/products/jlf/ed2/book/Appendix.B.html#89077
 *
 * Some images are by Gerhard Beck Copyright 2006.
 *
 * License for the actual images:
 * Copyright 2000 by Sun Microsystems, Inc. All
 * Rights Reserved.
 *
 * Sun grants you ("Licensee") a non-exclusive,
 * royalty free, license to use, and redistribute
 * this software graphics artwork, as individual
 * graphics or as a collection, as part of software
 * code or programs that you develop, provided that
 * i) this copyright notice and license accompany
 * the software graphics artwork; and ii) you do not
 * utilize the software graphics artwork in a manner
 * which is disparaging to Sun. Unless enforcement
 * is prohibited by applicable law, you may not
 * modify the graphics, and must use them true to
 * color and unmodified in every way.
 *
 * This software graphics artwork is provided "AS
 * IS," without a warranty of any kind. ALL EXPRESS
 * OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
 * OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN AND
 * ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING,
 * MODIFYING OR DISTRIBUTING THE SOFTWARE GRAPHICS
 * ARTWORK.
 *
 * IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE
 * FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR
 * DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL,
 * INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED
 * AND REGARDLESS OF THE THEORY OF LIABILITY,
 * ARISING OUT OF THE USE OF OR INABILITY TO USE
 * SOFTWARE GRAPHICS ARTWORK, EVEN IF SUN HAS BEEN
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 *
 * If any of the above provisions are held to be in
 * violation of applicable law, void, or
 * unenforceable in any jurisdiction, then such
 * provisions are waived to the extent necessary for
 * this Disclaimer to be otherwise enforceable in
 * such jurisdiction.
 *
 * @author  Gerhard Beck
 */
public class Icons
{
   public static final int SAVE = 0;
   public static final int ROTATE_RIGHT = 1;
   public static final int ROTATE_LEFT = 2;
   public static final int DELETE = 3;
   public static final int UNDO = 4;
   public static final int REDO = 5;
   public static final int REFRESH = 6;
   public static final int HELP = 7;
   public static final int NO_PICTURES = 8;
   public static final int ABOUT = 9;
   public static final int FULL_SCREEN = 10;
   public static final int GROW = 11;
   public static final int SHRINK = 12;
   public static final int RENAME = 13;
   public static final int PARK = 14;
   public static final int REPEAT = 15;
   public static final int BEGINNING = 16;
   public static final int END = 17;
   public static final int BASIC_SCREEN = 18;
   public static final int MOVIE = 19;
   public static final int STOP_MOVIE = 20;
   public static final int FULL_SCREEN_MOVIE = 21;
   public static final int SAVE_AS = 22;
   public static final int HOUR_GLASS = 23;
   public static final int BACK = 24;
   public static final int FORWARD = 25;
   public static final int JIBS_16 = 26;
   public static final int DIR_SUBS = 27;
   public static final int DIR_NO_SUBS = 28;
   public static final int DIRECTORY_LIST = 29;
   public static final int CLEAR = 30;
   public static final int COMIC_SCREEN = 31;
   public static final int THUMBNAIL = 32;


   private Icons()
   {
   	// Prevent public creation
   }

	public static BufferedImage getBufferedImage(String urlString)
	{
		return ImageUtil.toBufferedImage(getImage(urlString));
	}
	
	public static BufferedImage getBufferedImage(int type)
	{
		return ImageUtil.toBufferedImage(getImage(type));
	}
	
	/**
	 * Reads images from the jar file itself.
	 * Could work over Internet, but that wasn't really the plan
	 * and this doesn't have that kind of exception handling or caching.
	 * "/org/gerhardb/lib/util/Beginning.gif"
	 * @param url
	 * @return
	 */
	public static Image getImage(String urlString)
	{
		URL url = Icons.class.getResource(urlString);
		if (url == null) { return null; }
		return Toolkit.getDefaultToolkit().getImage(url);
	}
	
   public static Image getImage(int type)
   {
   	URL url = getURL(type);
   	if ( url == null ){return null;}
   	return Toolkit.getDefaultToolkit().getImage(url);   	
   }
   
   public static ImageIcon getIcon(int type)
   {
   	URL url = getURL(type);
   	if ( url == null ){return null;}
   	return new ImageIcon(url);
   }

   public static URL getURL(int type)
   {
      switch (type)
      {
         case SAVE:
            return getURL("general/Save16.gif"); //$NON-NLS-1$
         case SAVE_AS:
            return getURL("general/SaveAs16.gif"); //$NON-NLS-1$
         case DELETE:
            return getURL("general/Delete16.gif"); //$NON-NLS-1$
         case UNDO:
            return getURL("general/Undo16.gif"); //$NON-NLS-1$
         case REDO:
            return getURL("general/Redo16.gif"); //$NON-NLS-1$
         case REFRESH:
            return getURL("general/Refresh16.gif"); //$NON-NLS-1$
         case HELP:
            return getURL("general/Help16.gif"); //$NON-NLS-1$
         case BACK:
            return getURL("general/Back16.gif"); //$NON-NLS-1$
         case FORWARD:
            return getURL("general/Forward16.gif"); //$NON-NLS-1$
         case ABOUT:
            return getURL("general/About16.gif"); //$NON-NLS-1$
         case FULL_SCREEN:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/FullScreen16.gif"); //$NON-NLS-1$
         case COMIC_SCREEN:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/Comic16.gif"); //$NON-NLS-1$
         case GROW:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/Grow16.gif"); //$NON-NLS-1$
         case SHRINK:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/Shrink16.gif"); //$NON-NLS-1$
         case RENAME:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/Rename16.gif"); //$NON-NLS-1$
         case ROTATE_RIGHT:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/RotateRight16.gif"); //$NON-NLS-1$
         case ROTATE_LEFT:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/RotateLeft16.gif"); //$NON-NLS-1$
         case REPEAT:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/Repeat16.gif"); //$NON-NLS-1$
         case DIRECTORY_LIST:
            return Icons.class.getResource(
            	"/org/gerhardb/lib/util/DirectoryList.gif"); //$NON-NLS-1$
         case PARK:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/Park16.gif"); //$NON-NLS-1$
         case BEGINNING:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/Beginning.gif"); //$NON-NLS-1$
         case END:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/End.gif"); //$NON-NLS-1$
         case NO_PICTURES:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/NoPictures.gif"); //$NON-NLS-1$
         case MOVIE:
            return getURL("media/Movie16.gif"); //$NON-NLS-1$
         case STOP_MOVIE:
            return getURL("media/Stop16.gif"); //$NON-NLS-1$
         case BASIC_SCREEN:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/BasicScreen16.gif"); //$NON-NLS-1$
         case FULL_SCREEN_MOVIE:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/FullScreenMovie16.gif"); //$NON-NLS-1$
         case HOUR_GLASS:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/HourGlass.gif"); //$NON-NLS-1$
         case JIBS_16:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/jibs-16.gif"); //$NON-NLS-1$
         case DIR_SUBS:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/DirectoryWithSub.gif"); //$NON-NLS-1$
         case DIR_NO_SUBS:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/DirectoryNoSub.gif"); //$NON-NLS-1$
         case CLEAR:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/Clear.gif"); //$NON-NLS-1$
         case THUMBNAIL:
            return Icons.class.getResource(
               "/org/gerhardb/lib/util/Thumbnail.gif"); //$NON-NLS-1$
         default:
            return null;
      }
   }
   
   private static URL getURL(String path)
   {
      return Icons.class.getResource(
         "/com/sun/icons/toolbarButtonGraphics/" + path); //$NON-NLS-1$
   }
}
