/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.util;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.*;


/**
 * Miscellaneous
 */
public class Misc
{
	private static Cursor clsTransparentCursor;
	
	public static byte[] toByteArray(Object object)
	throws IOException
	{
     // Serialize to a byte array
     ByteArrayOutputStream bos = new ByteArrayOutputStream() ;
     ObjectOutput out = new ObjectOutputStream(bos) ;
     out.writeObject(object);
     out.close();
 
     // Get the bytes of the serialized object
     byte[] rtnMe = bos.toByteArray();
     return rtnMe;
	}

	public static Object toObject(byte[] bytes)
	throws Exception
	{
      // Deserialize from a byte array
		ObjectInputStream  in = new ObjectInputStream(new ByteArrayInputStream(bytes));
      Object rtnMe = in.readObject();
      in.close();
      return rtnMe;
	}	
	
	public static Cursor getTransparentCursor()
	{
		if (clsTransparentCursor == null)
		{
			int[] pixels = new int[16 * 16];
			Image image = Toolkit.getDefaultToolkit().createImage(
					new MemoryImageSource(16, 16, pixels, 0, 16));
			clsTransparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(
					image, new Point(0, 0), "invisiblecursor"); //$NON-NLS-1$
		}
		return clsTransparentCursor;
	}


}
