/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.util;

import java.util.*;
import java.lang.ref.*;

/**
 * DOES NOT WORK WITH JAVA 6 BECAUSE REMOVE CAUSES PROBLEM.
 * From Dr. Heinz Kabutz
 * http://www.javaspecialists.eu/archive/Issue015.html
 * http://archive.devx.com/java/free/articles/Kabutz01/Kabutz01-2.asp
 */

@SuppressWarnings("unchecked")
public class SoftValueHashMapOLD extends AbstractMap
{
	/** The internal HashMap that will hold the SoftReference. */
	private final Map hash = new HashMap();
	/** The number of "hard" references to hold internally. */
	private final int HARD_SIZE;
	/** The FIFO list of hard references, order of last access. */
	private final LinkedList hardCache = new LinkedList();
	/** Reference queue for cleared SoftReference objects. */
	private final ReferenceQueue queue = new ReferenceQueue();

	public SoftValueHashMapOLD()
	{
		this(50);
	}

	public SoftValueHashMapOLD(int hardSize)
	{
		this.HARD_SIZE = hardSize;
	}

	@Override
	public Object get(Object key)
	{
		Object result = null;
		// We get the SoftReference represented by that key
		SoftReference soft_ref = (SoftReference) this.hash.get(key);
		if (soft_ref != null)
		{
			// From the SoftReference we get the value, which can be
			// null if it was not in the map, or it was removed in
			// the processQueue() method defined below
			result = soft_ref.get();
			if (result == null)
			{
				// If the value has been garbage collected, remove the
				// entry from the HashMap.
				this.hash.remove(key);
			}
			else
			{
				// We now add this object to the beginning of the hard
				// reference queue.  One reference can occur more than
				// once, because lookups of the FIFO queue are slow, so
				// we don't want to search through it each time to remove
				// duplicates.
				this.hardCache.addFirst(result);
				if (this.hardCache.size() > this.HARD_SIZE)
				{
					// Remove the last entry if list longer than HARD_SIZE
					this.hardCache.removeLast();
				}
			}
		}
		return result;
	}

	/** Here we put the key, value pair into the HashMap using
	 a SoftValue object. */
	@Override
	public Object put(Object key, Object value)
	{
		processQueue(); // throw out garbage collected values first
		return this.hash.put(key, new SoftValue(value, key, this.queue));
	}

	@Override
	public Object remove(Object key)
	{
		processQueue(); // throw out garbage collected values first
		return this.hash.remove(key);
	}

	@Override
	public void clear()
	{
		this.hardCache.clear();
		processQueue(); // throw out garbage collected values
		this.hash.clear();
	}

	@Override
	public int size()
	{
		processQueue(); // throw out garbage collected values first
		return this.hash.size();
	}

	@Override
	public Set entrySet()
	{
		// no, no, you may NOT do that!!! GRRR
		throw new UnsupportedOperationException();
	}
	
	/** We define our own subclass of SoftReference which contains
	 not only the value but also the key to make it easier to find
	 the entry in the HashMap after it's been garbage collected. */
	private static class SoftValue extends SoftReference
	{
		final Object key; // always make data member final

		/** Did you know that an outer class can access private data
		 members and methods of an inner class?  I didn't know that!
		 I thought it was only the inner class who could access the
		 outer class's private information.  An outer class can also
		 access private members of an inner class inside its inner
		 class. */
		SoftValue(Object k, Object daKey, ReferenceQueue q)
		{
			super(k, q);
			this.key = daKey;
		}
		
		@Override
		protected void finalize()
		{
			System.out.println("Finalizing a SoftValue for: " + this.key);
		}
	}

	/** Here we go through the ReferenceQueue and remove garbage
	 collected SoftValue objects from the HashMap by looking them
	 up using the SoftValue.key data member. */
	private void processQueue()
	{
		SoftValue sv;
		while ((sv = (SoftValue) this.queue.poll()) != null)
		{
			this.hash.remove(sv.key); // we can access private data!
		}
	}
}