/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.util.app;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;

public class AboutBox extends Dialog implements ActionListener
{
	JButton myOkBtn = new JButton();
	Manifest myManifest = AboutBox.readManifest();
	
	/*
	 * private static ResourceBundle getResources() { String pkgName =
	 * AboutBox.class.getPackage().getName(); StringBuffer buf = new
	 * StringBuffer(pkgName.length() + 13);
	 * buf.append(pkgName).append(".Localization");
	 * 
	 * return ResourceBundle.getBundle(buf.toString()); }
	 * 
	 */
	public AboutBox(Frame parent)
	{
		super(parent);
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		super.setTitle(Jibs.getString("AboutBox.title")); //$NON-NLS-1$
		super.setResizable(false);
		super.setModal(true);

		JPanel buttons = new JPanel(new FlowLayout(FlowLayout.CENTER));
		buttons.add(this.myOkBtn);
		this.myOkBtn.setText(Jibs.getString("ok")); //$NON-NLS-1$
		this.myOkBtn.addActionListener(this);

		JPanel base = new JPanel(new BorderLayout());
		base.add(makeCopyright(), BorderLayout.CENTER);
		base.add(buttons, BorderLayout.SOUTH);

		super.add(base);
		pack();
		SwingUtils.centerOnScreen(this);
		super.setVisible(true);
	}

	private JPanel makeCopyright()
	{
		String jibsVersion = getJibsVersion(this.myManifest);
		
		String warranty = ""  //$NON-NLS-1$
				+ "This program is distributed in the hope that it will be "  //$NON-NLS-1$
				+ "useful, but WITHOUT ANY WARRANTY; without even the implied " //$NON-NLS-1$
				+ "warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR " //$NON-NLS-1$
				+ "PURPOSE.  See the License for more details. \n\n" //$NON-NLS-1$
				+ "The license can be found in Help menu under License. \n\n" //$NON-NLS-1$
				+ "Includes software from the following projects or sources: \n" //$NON-NLS-1$
				+ "Oracle (Sun Microsystems) \n"
				+ "http://commons.apache.org/sanselan/ \n" //$NON-NLS-1$
				+ "http://saic491.sourceforge.net/ \n" //$NON-NLS-1$
				+ "http://www.drewnoakes.com/code/exif/ \n"  //$NON-NLS-1$
				+ "http://launch4j.sourceforge.net/ \n"  //$NON-NLS-1$
				+ "http://rsb.info.nih.gov/ij/index.html \n"  //$NON-NLS-1$
				+ "http://bigwww.epfl.ch/algorithms/ijplugins/resize/ \n\n"  //$NON-NLS-1$
				+ "Includes Resize, an ImageJ plugin to resize an image using high-quality interpolation. Written by Arrate Muoz, David Leroux, Daniel Sage and Michael Unser at the Biomedical Image Group (BIG), EPFL, Switzerland \n\n" //$NON-NLS-1$
				+ "Reference:  A. Muoz Barrutia, T. Blu, M. Unser, \"Least-Squares Image Resizing Using Finite Differences,\" IEEE Transactions on Image Processing, vol. 10, no. 9, pp. 1365-1378, September 2001.\n" //$NON-NLS-1$
				;  

		JTextArea showWarrenty = new JTextArea(warranty);
		showWarrenty.setLineWrap(true);
		showWarrenty.setWrapStyleWord(true);
		showWarrenty.setEditable(false);
		showWarrenty.setRows(10);
		showWarrenty.setColumns(40);

		JPanelRows basePanel = new JPanelRows(FlowLayout.CENTER);

		JPanel row = basePanel.topRow();
		row.add(new JLabel(
				"<html><big>JIBS -- "  //$NON-NLS-1$
				+ Jibs.getString("AboutBox.0") //$NON-NLS-1$
				+ "</big></html>")); //$NON-NLS-1$

		row = basePanel.nextRow();
		row.add(new JLabel(Jibs.getString("AboutBox.1") + Jibs.getString("colon") + " " + jibsVersion)); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$

		row = basePanel.nextRow();
		row.add(new JLabel(Jibs.getString("AboutBox.3") + //$NON-NLS-1$
				" Gerhard Beck 2010")); //$NON-NLS-1$

		row = basePanel.nextRow();
		row.add(new JLabel(Jibs.getString("AboutBox.4") + Jibs.getString("colon"))); //$NON-NLS-1$ //$NON-NLS-2$

		row = basePanel.nextRow();
		row.add(new JLabel(
				"<html><big><b>http://www.jibs.us/</b></big></html>")); //$NON-NLS-1$

		row = basePanel.nextRow();
		row.add(new JLabel("http://img-browse-sort.sourceforge.net/"));  //$NON-NLS-1$

		row = basePanel.nextRow();
		row.add(new JScrollPane(showWarrenty));

		return basePanel;
	}

	@Override
	protected void processWindowEvent(WindowEvent e)
	{
		if (e.getID() == WindowEvent.WINDOW_CLOSING)
		{
			cancel();
		}
		super.processWindowEvent(e);
	}

	void cancel()
	{
		dispose();
	}

	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == this.myOkBtn)
		{
			cancel();
		}
	}
	
	public static String getJibsVersion(Manifest manifest)
	{
		String jibsVersion = "unknown";
		if (manifest != null)
		{
			Attributes attr = manifest.getMainAttributes();
			String version = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
			if(version != null && version.length() > 0)
			{
				jibsVersion = version;
			}
		}
		return jibsVersion;
	}
	
	public static Manifest readManifest()
	{
		try
		{
			String classContainer = AboutBox.class.getProtectionDomain().getCodeSource().getLocation().toString();
			URL manifestUrl = new URL("jar:" + classContainer + "!/META-INF/MANIFEST.MF");
			Manifest manifest = new Manifest(manifestUrl.openStream());
			return manifest;
		}
		catch(Exception ex)
		{
			//ex.printStackTrace();
			System.out.println("No Manifest found.  Likely you are running in Eclipse.  Run from Jar.");
			return null;
		}
	}


	// ==========================================================================
	// Main
	// ==========================================================================
	public static void main(String[] args)
	{
		try
		{
			Manifest manifest = AboutBox.readManifest();
			Attributes attr = manifest.getMainAttributes();

			String CREATED_BY = attr.getValue("Created-by");
			String SOFTWARE_VENDOR = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
			String SOFTWARE_VENDOR_ID = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR_ID);
			String SOFTWARE_VENDOR_TITLE = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);	
			String SOFTWARE_VERSION = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
			String SOFTWARE_VENDOR_URL = attr.getValue(Attributes.Name.IMPLEMENTATION_URL);		
			
			System.out.println("CREATED_BY: " + CREATED_BY);
			System.out.println("SOFTWARE_VENDOR: " + SOFTWARE_VENDOR);
			System.out.println("SOFTWARE_VENDOR_ID: " + SOFTWARE_VENDOR_ID);
			System.out.println("SOFTWARE_VENDOR_TITLE: " + SOFTWARE_VENDOR_TITLE);
			System.out.println("SOFTWARE_VERSION: " + SOFTWARE_VERSION);
			System.out.println("SOFTWARE_VENDOR_URL: " + SOFTWARE_VENDOR_URL);
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
		
		try
		{
			JFrame f = new JFrame("File Tree Test"); //$NON-NLS-1$
			f.getContentPane().add(new JLabel("test")); //$NON-NLS-1$
			f.setSize(300, 300);
			f.addWindowListener(new WindowAdapter()
			{
				@Override
				public void windowClosing(WindowEvent evt)
				{
					System.exit(0);
				}
			});
			f.setVisible(true);
			new AboutBox(f);
		} catch (Exception ex)
		{
			System.out.println(ex.getMessage());
		}

		System.out.println("Main Exiting Normally"); //$NON-NLS-1$
	} 

}
