/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.gerhardb.lib.util.app;

import java.awt.Desktop;
import java.net.URI;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import org.gerhardb.jibs.Jibs;

/**
 * Hacks to keep main code base at 4.2 while using new Java 6 features
 * as needed.
 * @author Gerhard
 *
 */
public class AppUtils
{	
	public static boolean helpToBrowser(JFrame ss)
	{
		if (Desktop.isDesktopSupported())
		{
			Desktop desktop = Desktop.getDesktop();
			if (desktop.isSupported(Desktop.Action.BROWSE))
			{
		      int create = JOptionPane.showConfirmDialog(ss, 
		      		Jibs.getString("SortScreen.10") + "\n" +
						Jibs.getString("SortScreen.52"), //$NON-NLS-1$
						Jibs.getString("SortScreen.51"), //$NON-NLS-1$
		            JOptionPane.YES_NO_OPTION);
				if (create == JOptionPane.YES_OPTION)
				{
					desktop = Desktop.getDesktop();
					try
					{
						desktop.browse(new URI("http://www.jibs.us/"));
					}
					catch(Exception ex)
					{
						ex.printStackTrace();
					}			
				}
				return true;
			}
			return false;
		}
		return false;
	}
	
}
