package ch.epfl.bigwww;

import ij.*;
import ij.process.*;

import java.awt.image.BufferedImage;
import java.io.File;

import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.util.startup.AppStarter;

/**
 * Basic tests on the Resize code base.
 * 
 * Source code  provided Daniel Sage.
 * 
 * Permission for use in JIBS granted by Daniel Sage on 13 April 2011 under the following terms:
 * 
 * Credit:
 * Resize: An ImageJ plugin to resize an image using high-quality interpolation
 * Written by Arrate Munoz, David Leroux, Daniel Sage and Michael Unser at the
 * Biomedical Image Group (BIG), EPFL, Switzerland
 * 
 * Reference
 * A. Munoz Barrutia, T. Blu, M. Unser,
 * "Least-Squares Image Resizing Using Finite Differences," IEEE Transactions on
 * Image Processing, vol. 10, no. 9, pp. 1365-1378, September 2001.
 * 
 * @author gerhard
 *
 */
public class BasicResizeTests
{
	static String ORIGINAL = "D:/trash/a-original.jpg";

	private static void testPlugin()
	{
		BufferedImage buffImage = ImageFactory.getImageFactory().getImageEZ(new File(ORIGINAL));
		
		ImageProcessor processor = new ColorProcessor(buffImage);
		ImagePlus imp = new ImagePlus("Orginial A", buffImage);
		
		Resize_ resizeDialog = new Resize_();
		
		// First argument can be any non-null item which is not "about"
		resizeDialog.setup("SHOW", imp);
		
		resizeDialog.run(processor);
	}
	
			
	public static void main(String[] args)
	{
		AppStarter.startUpApp(args, "org.gerhardb.jibs.Jibs", true);
		testPlugin();
	}

}
