/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.print;

/*
import java.text.DecimalFormat;

import ij.*;
import ij.gui.*;
import ij.plugin.filter.*;
import ij.plugin.*;
import ij.process.*;
*/

public class BigResizeTests
{
	//Resize resize = new Resize();
}
	/*
	 * 
	 * 
	 * 
	 * 
	this.display1.reset();
	this.display2.reset();
	this.display3.reset();
	this.display4.reset();

	Resize resize = new Resize();
	
	double zoom = new Double(this.txtZoom.getText()).doubleValue() / 100.0D;
	int n1 = new Integer(this.choiceN1.getSelectedItem()).intValue();
	int n2 = new Integer(this.choiceN2.getSelectedItem()).intValue();
	int spline = 0;

	this.display1.setImage(this.image1);
	this.display1.writeMessage("(1) Original Image");

	if (this.choiceMethod.getSelectedItem() == "Interpolation") {
	  spline = n2;
	  n1 = -1;
	}

	if (this.choiceMethod.getSelectedItem() == "Least squares") {
	  spline = n2;
	  n1 = n2;
	}

	if (this.choiceMethod.getSelectedItem() == "Oblique projection") {
	  spline = n2;
	}

	this.display1.writeMessage(this.choiceMethod.getSelectedItem() + "  " + n1);
	if (zoom < 0.02D) {
	  this.txtZoom.setText("2");
	  zoom = 0.01D;
	}
	if (zoom > 1.0D) {
	  this.txtZoom.setText("100");
	  zoom = 1.0D;
	}

	ImageAccess src = new ImageAccess(256, 256, 2);
	src.copy(this.image1);

	int w = 256;
	int h = 256;
	int w2 = (int)Math.round(Math.round((w - 1) * zoom) / zoom);
	while (w - 1 - w2 != 0) {
	  w += 1;
	  w2 = (int)Math.round(Math.round((w - 1) * zoom) / zoom);
	}
	int width2 = (int)Math.round((w - 1) * zoom) + 1;
	int h2 = (int)Math.round(Math.round((h - 1) * zoom) / zoom);
	while (h - 1 - h2 != 0) {
	  h += 1;
	  h2 = (int)Math.round(Math.round((h - 1) * zoom) / zoom);
	}
	int height2 = (int)Math.round((h - 1) * zoom) + 1;

	ImageAccess tmp1 = new ImageAccess(width2, height2, 2);
	resize.computeZoom(this.image1, tmp1, n1, n2, spline, zoom, zoom, 0.0D, 0.0D, 1);
	int x0 = (256 - width2) / 2;
	int y0 = (256 - height2) / 2;
	this.image2.setConstant(0.0D);
	this.image2.copy(tmp1, 0, 0, x0, y0, width2, height2);
	this.display2.setImage(this.image2);
	this.display2.writeMessage("(2) Reduced Image");

	zoom = 1.0D / zoom;
	w = width2;
	h = height2;
	w2 = (int)Math.round(Math.round((w - 1) * zoom) / zoom);
	while (w - 1 - w2 != 0) {
	  w += 1;
	  w2 = (int)Math.round(Math.round((w - 1) * zoom) / zoom);
	}
	width2 = (int)Math.round((w - 1) * zoom) + 1;
	h2 = (int)Math.round(Math.round((h - 1) * zoom) / zoom);
	while (h - 1 - h2 != 0) {
	  h += 1;
	  h2 = (int)Math.round(Math.round((h - 1) * zoom) / zoom);
	}
	height2 = (int)Math.round((h - 1) * zoom) + 1;

	ImageAccess tmp2 = new ImageAccess(width2, height2, 2);
	resize.computeZoom(tmp1, tmp2, n1, n2, spline, zoom, zoom, 0.0D, 0.0D, 1);

	for (int x = 0; x < width2; x++) {
	  for (int y = 0; y < height2; y++)
	    this.image3.putPixel(x, y, tmp2.getPixel(x, y));
	}
	this.image3disp.copy(this.image3);
	this.image3disp.normalizeContrast(0.0D, 255.0D);
	this.display3.setImage(this.image3disp, this.image3);
	this.display3.writeMessage("(3) Reduced then expanded Image");

	this.image4.copy(this.image1);
	this.image4.subtract(this.image3);
	this.image4disp.copy(this.image4);
	this.image4disp.add(127.5D);

	this.display4.setImage(this.image4disp, this.image4);
	this.display4.writeMessage("(4) Difference (1) - (3)");

	Snr snrCompute = new Snr();
	double snrc = Snr.compute(src, this.image3, 100.0D);
	DecimalFormat df = new DecimalFormat();
	String s = df.format(snrc) + " dB";
	this.snrLabel.setText("SNR: " + s);
	*/



/*

public boolean action(Event ev, Object arg)
{
this.display1.reset();
this.display2.reset();
this.display3.reset();
this.display4.reset();

Resize resize = new Resize();
double zoom = new Double(this.txtZoom.getText()).doubleValue() / 100.0D;
int n1 = new Integer(this.choiceN1.getSelectedItem()).intValue();
int n2 = new Integer(this.choiceN2.getSelectedItem()).intValue();
int spline = 0;

this.display1.setImage(this.image1);
this.display1.writeMessage("(1) Original Image");

if (this.choiceMethod.getSelectedItem() == "Interpolation") {
  spline = n2;
  n1 = -1;
}

if (this.choiceMethod.getSelectedItem() == "Least squares") {
  spline = n2;
  n1 = n2;
}

if (this.choiceMethod.getSelectedItem() == "Oblique projection") {
  spline = n2;
}

this.display1.writeMessage(this.choiceMethod.getSelectedItem() + "  " + n1);
if (zoom < 0.02D) {
  this.txtZoom.setText("2");
  zoom = 0.01D;
}
if (zoom > 1.0D) {
  this.txtZoom.setText("100");
  zoom = 1.0D;
}

ImageAccess src = new ImageAccess(256, 256, 2);
src.copy(this.image1);

int w = 256;
int h = 256;
int w2 = (int)Math.round(Math.round((w - 1) * zoom) / zoom);
while (w - 1 - w2 != 0) {
  w += 1;
  w2 = (int)Math.round(Math.round((w - 1) * zoom) / zoom);
}
int width2 = (int)Math.round((w - 1) * zoom) + 1;
int h2 = (int)Math.round(Math.round((h - 1) * zoom) / zoom);
while (h - 1 - h2 != 0) {
  h += 1;
  h2 = (int)Math.round(Math.round((h - 1) * zoom) / zoom);
}
int height2 = (int)Math.round((h - 1) * zoom) + 1;

ImageAccess tmp1 = new ImageAccess(width2, height2, 2);
resize.computeZoom(this.image1, tmp1, n1, n2, spline, zoom, zoom, 0.0D, 0.0D, 1);
int x0 = (256 - width2) / 2;
int y0 = (256 - height2) / 2;
this.image2.setConstant(0.0D);
this.image2.copy(tmp1, 0, 0, x0, y0, width2, height2);
this.display2.setImage(this.image2);
this.display2.writeMessage("(2) Reduced Image");

zoom = 1.0D / zoom;
w = width2;
h = height2;
w2 = (int)Math.round(Math.round((w - 1) * zoom) / zoom);
while (w - 1 - w2 != 0) {
  w += 1;
  w2 = (int)Math.round(Math.round((w - 1) * zoom) / zoom);
}
width2 = (int)Math.round((w - 1) * zoom) + 1;
h2 = (int)Math.round(Math.round((h - 1) * zoom) / zoom);
while (h - 1 - h2 != 0) {
  h += 1;
  h2 = (int)Math.round(Math.round((h - 1) * zoom) / zoom);
}
height2 = (int)Math.round((h - 1) * zoom) + 1;

ImageAccess tmp2 = new ImageAccess(width2, height2, 2);
resize.computeZoom(tmp1, tmp2, n1, n2, spline, zoom, zoom, 0.0D, 0.0D, 1);

for (int x = 0; x < width2; x++) {
  for (int y = 0; y < height2; y++)
    this.image3.putPixel(x, y, tmp2.getPixel(x, y));
}
this.image3disp.copy(this.image3);
this.image3disp.normalizeContrast(0.0D, 255.0D);
this.display3.setImage(this.image3disp, this.image3);
this.display3.writeMessage("(3) Reduced then expanded Image");

this.image4.copy(this.image1);
this.image4.subtract(this.image3);
this.image4disp.copy(this.image4);
this.image4disp.add(127.5D);

this.display4.setImage(this.image4disp, this.image4);
this.display4.writeMessage("(4) Difference (1) - (3)");

Snr snrCompute = new Snr();
double snrc = Snr.compute(src, this.image3, 100.0D);
DecimalFormat df = new DecimalFormat();
String s = df.format(snrc) + " dB";
this.snrLabel.setText("SNR: " + s);

*/




/*
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GUI;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextListener;
import java.text.DecimalFormat;

public class Resize_
  implements PlugInFilter, ActionListener
{
  private boolean dialogOK = true;
  private ImagePlus imp;
  private ImageStack stack;
  private double sizeX;
  private double sizeY;
  private double zoomX;
  private double zoomY;
  private int interpDegree;
  private int analyDegree;
  private int syntheDegree;
  private boolean UnitPixelsX = true;
  private boolean UnitPixelsY = true;
  private boolean constraintRatio = true;
  private String interpolation = "";
  private String method = "";
  private int nx;
  private int ny;
  private Dialog dlg = new Dialog(new Frame(), "Resize");
  private Button bnOK = new Button();
  private Button bnCancel = new Button();
  private TextField txtXScale = new TextField(10);
  private TextField txtYScale = new TextField(10);
  private Choice choiceUnitX = new Choice();
  private Choice choiceUnitY = new Choice();
  private Choice choiceInterpolation = new Choice();
  private Choice choiceMethod = new Choice();
  private Checkbox chkAspectRatio;
  private TextListener tlx;
  private TextListener tly;

  public void run(ImageProcessor ip)
  {
    this.interpDegree = 3;
    this.syntheDegree = 3;
    this.analyDegree = 3;

    int nx = this.imp.getWidth();
    int ny = this.imp.getHeight();
    if (nx > 3000)
      this.analyDegree = 1;
    if (ny > 3000) {
      this.analyDegree = 1;
    }
    if (this.interpolation.equalsIgnoreCase("Linear")) {
      this.interpDegree = 1;
      this.syntheDegree = 1;
      this.analyDegree = 1;
    }

    if (this.method.equalsIgnoreCase("Interpolation")) {
      this.analyDegree = -1;
    }

    Resize resize = new Resize();

    if (this.imp.getType() == 4) {
      ImageAccess[] out = new ImageAccess[3];
      for (int c = 0; c < 3; c++) {
        ImageAccess in = new ImageAccess((ColorProcessor)ip, c);
        out[c] = new ImageAccess((int)this.sizeX, (int)this.sizeY);
        resize.computeZoom(in, out[c], this.analyDegree, this.syntheDegree, this.interpDegree, this.zoomY, this.zoomX, 0.0D, 0.0D, false);
      }
      byte[] r = (byte[])(byte[])out[0].createByteProcessor().getPixels();
      byte[] g = (byte[])(byte[])out[1].createByteProcessor().getPixels();
      byte[] b = (byte[])(byte[])out[2].createByteProcessor().getPixels();
      ColorProcessor cp = new ColorProcessor((int)this.sizeX, (int)this.sizeY);
      cp.setRGB(r, g, b);
      this.stack.addSlice("", cp);
    }
    else {
      ImageAccess in = new ImageAccess(ip);
      ImageAccess out = new ImageAccess((int)this.sizeX, (int)this.sizeY);
      resize.computeZoom(in, out, this.analyDegree, this.syntheDegree, this.interpDegree, this.zoomY, this.zoomX, 0.0D, 0.0D, false);
      switch (this.imp.getType()) {
      case 0:
        this.stack.addSlice("", out.createByteProcessor());
        break;
      case 1:
        this.stack.addSlice("", createShortProcessor(out));
        break;
      case 2:
        this.stack.addSlice("", out.createFloatProcessor());
      }

    }

    if (this.stack.getSize() == this.imp.getStack().getSize()) {
      ImagePlus impResult = new ImagePlus(this.imp.getTitle(), this.stack);
      impResult.updateAndDraw();
      impResult.show();
    }
  }

  public int setup(String arg, ImagePlus imp)
  {
    if (IJ.versionLessThan("1.21a")) {
      return 4096;
    }
    this.imp = imp;
    if (arg.equals("about")) {
      showAbout();
      return 4096;
    }

    if (imp == null) {
      IJ.error("Input image required");
      return 4096;
    }

    if (!checkSizeImage()) {
      return 4096;
    }
    doDialog();
    if (!this.dialogOK) {
      return 4096;
    }
    if (!checkParameters()) {
      return 4096;
    }
    int nx = imp.getWidth();
    int ny = imp.getHeight();
    int slices = imp.getStackSize();
    int type = imp.getType();

    if (this.UnitPixelsX == true) {
      this.zoomX = (this.sizeX / nx);
    }
    else {
      this.zoomX = (this.sizeX / 100.0D);
    }

    if (this.UnitPixelsY == true) {
      this.zoomY = (this.sizeY / ny);
    }
    else {
      this.zoomY = (this.sizeY / 100.0D);
    }

    this.sizeX = (int)Math.round(nx * this.zoomX);
    this.sizeY = (int)Math.round(ny * this.zoomY);

    this.stack = new ImageStack((int)this.sizeX, (int)this.sizeY);

    return 61;
  }

  public void showAbout()
  {
    IJ.showMessage("About Resize_...", "Compute a resized version of an input image \nusing either interpolation or least-squares approximation method\n\nSwiss Federal Institute of Technology Lausanne (EPFL) \nBiomedical Imaging Group\n");
  }

  private boolean checkSizeImage()
  {
    this.nx = this.imp.getProcessor().getWidth();
    this.ny = this.imp.getProcessor().getHeight();

    if (this.nx <= 3) {
      IJ.error("Size X too small.");
      return false;
    }
    if (this.ny <= 3) {
      IJ.error("Size Y too small.");
      return false;
    }

    return true;
  }

  private boolean checkParameters()
  {
    if (this.sizeY <= 3.0D) {
      IJ.error("Final Height too small.");
      return false;
    }
    if (this.sizeX <= 3.0D) {
      IJ.error("Final Width too small.");
      return false;
    }
    return true;
  }

  private void doDialog()
  {
    GridBagLayout grid = new GridBagLayout();
    GridBagConstraints c = new GridBagConstraints();

    this.dlg.setLayout(grid);

    this.txtXScale.setText("" + this.nx / 2);
    this.txtXScale.setColumns(10);
    this.txtYScale.setText("" + this.ny / 2);
    this.txtYScale.setColumns(10);

    this.choiceUnitX.add("Pixels");
    this.choiceUnitX.add("Percent");
    this.choiceUnitX.select("Pixels");

    this.choiceUnitY.add("Pixels");
    this.choiceUnitY.add("Percent");
    this.choiceUnitY.select("Pixels");

    Panel pnX = new Panel();
    pnX.setLayout(new FlowLayout(1, 5, 0));
    pnX.add(this.txtXScale);
    pnX.add(this.choiceUnitX);

    Panel pnY = new Panel();
    pnY.setLayout(new FlowLayout(1, 5, 0));
    pnY.add(this.txtYScale);
    pnY.add(this.choiceUnitY);

    this.chkAspectRatio = new Checkbox("Constrain Aspect Ratio", true);

    this.choiceInterpolation.add("Linear");
    this.choiceInterpolation.add("Cubic");
    this.choiceInterpolation.select("Cubic");

    this.choiceMethod.add("Interpolation");
    this.choiceMethod.add("Least-Squares");
    this.choiceMethod.select("Least-Squares");

    buildCell(grid, c, 0, 0, 1, 1, new Label("Width"));
    buildCell(grid, c, 1, 0, 1, 1, pnX);

    buildCell(grid, c, 0, 1, 1, 1, new Label("Height"));
    buildCell(grid, c, 1, 1, 1, 1, pnY);

    buildCell(grid, c, 1, 3, 1, 1, this.chkAspectRatio);

    buildCell(grid, c, 0, 4, 1, 1, new Label("Method"));
    buildCell(grid, c, 1, 4, 1, 1, this.choiceMethod);
    buildCell(grid, c, 0, 5, 1, 1, new Label("Spline"));
    buildCell(grid, c, 1, 5, 1, 1, this.choiceInterpolation);

    Panel buttons = new Panel();
    buttons.setLayout(new FlowLayout(1, 5, 0));
    this.bnCancel = new Button("Cancel");
    this.bnCancel.addActionListener(this);
    buttons.add(this.bnCancel);
    this.bnOK = new Button("  OK  ");
    buttons.add(this.bnOK);
    this.bnOK.addActionListener(this);

    c.gridx = 1;
    c.gridy = 6;
    c.gridwidth = 1;
    c.gridheight = 1;
    c.anchor = 13;
    c.insets = new Insets(20, 5, 5, 5);
    grid.setConstraints(buttons, c);
    this.dlg.add(buttons);

    this.chkAspectRatio.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        if ((Resize_.this.chkAspectRatio.getState() == true) && (!Resize_.this.constraintRatio)) {
          Resize_.access$102(Resize_.this, true);
          Resize_.this.constraintAspectRatioX();
        }
        if ((!Resize_.this.chkAspectRatio.getState()) && (Resize_.this.constraintRatio == true)) {
          Resize_.access$102(Resize_.this, false);
          Resize_.this.constraintAspectRatioX();
        }
      }
    });
    this.choiceUnitX.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        String unit = Resize_.this.choiceUnitX.getSelectedItem();
        double x = Resize_.this.getDoubleValue(Resize_.this.txtXScale, 0.0D, Resize_.this.nx, 1.7976931348623157E+308D);
        if ((unit.equals("Pixels")) && (!Resize_.this.UnitPixelsX)) {
          Resize_.access$702(Resize_.this, true);
          long px = Math.round(x / 100.0D * Resize_.this.nx);
          Resize_.this.txtXScale.setText(new Long(px).toString());
        }
        if ((unit.equals("Percent")) && (Resize_.this.UnitPixelsX == true)) {
          Resize_.access$702(Resize_.this, false);
          double px = x / Resize_.this.nx * 100.0D;
          Resize_.this.txtXScale.setText(Resize_.this.convertDoubleToString3(px));
        }
      }
    });
    this.choiceUnitY.addItemListener(new ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        String unit = Resize_.this.choiceUnitY.getSelectedItem();
        double y = Resize_.this.getDoubleValue(Resize_.this.txtYScale, 0.0D, Resize_.this.ny, 1.7976931348623157E+308D);
        if ((unit.equals("Pixels")) && (!Resize_.this.UnitPixelsY)) {
          Resize_.access$1202(Resize_.this, true);
          long py = Math.round(y / 100.0D * Resize_.this.ny);
          Resize_.this.txtYScale.setText(new Long(py).toString());
        }
        if ((unit.equals("Percent")) && (Resize_.this.UnitPixelsY == true)) {
          Resize_.access$1202(Resize_.this, false);
          double py = y / Resize_.this.ny * 100.0D;
          Resize_.this.txtYScale.setText(Resize_.this.convertDoubleToString3(py));
        }
      }
    });
    this.txtXScale.addKeyListener(new KeyListener() {
      public void keyReleased(KeyEvent e) {
        Resize_.this.bnOK.setEnabled(false);
        if (!Resize_.this.txtXScale.getText().equals("")) {
          double p = 0.0D;
          try {
            if (Resize_.this.UnitPixelsX == true) {
              p = Integer.parseInt(Resize_.this.txtXScale.getText());
            }
            else
              p = Double.valueOf(Resize_.this.txtXScale.getText()).doubleValue();
          }
          catch (NumberFormatException n)
          {
          }
          if (p > 0.0D) {
            Resize_.this.bnOK.setEnabled(true);
            Resize_.this.constraintAspectRatioY();
          }
        }
      }

      public void keyTyped(KeyEvent e)
      {
      }

      public void keyPressed(KeyEvent e)
      {
      }
    });
    this.txtYScale.addKeyListener(new KeyListener() {
      public void keyReleased(KeyEvent e) {
        Resize_.this.bnOK.setEnabled(false);
        if (!Resize_.this.txtYScale.getText().equals("")) {
          double p = 0.0D;
          try {
            if (Resize_.this.UnitPixelsY == true) {
              p = Integer.parseInt(Resize_.this.txtYScale.getText());
            }
            else
              p = Double.valueOf(Resize_.this.txtYScale.getText()).doubleValue();
          }
          catch (NumberFormatException n)
          {
          }
          if (p > 0.0D) {
            Resize_.this.bnOK.setEnabled(true);
            Resize_.this.constraintAspectRatioX();
          }
        }
      }

      public void keyTyped(KeyEvent e)
      {
      }

      public void keyPressed(KeyEvent e)
      {
      }
    });
    this.dlg.setModal(true);
    this.dlg.pack();

    GUI.center(this.dlg);
    this.dlg.setVisible(true);
    IJ.wait(250);
  }

  private void buildCell(GridBagLayout gbl, GridBagConstraints gbc, int x, int y, int w, int h, Component Comp)
  {
    gbc.gridx = x;
    gbc.gridy = y;
    gbc.gridwidth = w;
    gbc.gridheight = h;
    gbc.anchor = 18;
    gbc.insets = new Insets(5, 5, 5, 5);
    gbl.setConstraints(Comp, gbc);
    this.dlg.add(Comp);
  }
  */