package org.gerhardb.lib.print;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import org.gerhardb.lib.image.*;

import com.itextpdf.text.*;
import com.itextpdf.text.pdf.*;

/**
 * Original code borrowed from the book "iText in Action - 2nd Edition"
 * written by Bruno Lowagie (ISBN: 9781935182610)
 */
public class ITextDemo
{
	static final String ALPHABET = "ABDCEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz 123456789 ~!@#$%^&*()_+ `-={}|[]<>?,.:;'/\\\"";
	
	/**
	 * Creates a PDF document.
	 * @param filename the path to the new PDF document
	 * @throws    DocumentException 
	 * @throws    IOException 
	 */
	public void createPdf(String filename) throws DocumentException, IOException
	{
		BaseFont font = BaseFont.createFont();
		System.out.println("Each Point is 1/72 inch");
		System.out.println("Width 1000: " + font.getWidth(ALPHABET));
		System.out.println("Width Point: " + font.getWidthPoint(ALPHABET, 12.0f));
		
		System.out.println("Ascent 1000: " + font.getAscent(ALPHABET));
		System.out.println("Ascent 12pt: " + font.getAscentPoint(ALPHABET, 12.0f));
		System.out.println("Decent 1000: " + font.getDescent(ALPHABET));
		System.out.println("Decent 12pt: " + font.getDescentPoint(ALPHABET, 12.0f));
		

		System.out.println("Ascent 10pt: " + font.getAscentPoint(ALPHABET, 10.0f));
		System.out.println("Decent 10pt: " + font.getDescentPoint(ALPHABET, 10.0f));

		System.out.println("Ascent 14pt: " + font.getAscentPoint(ALPHABET, 14.0f));
		System.out.println("Decent 14pt: " + font.getDescentPoint(ALPHABET, 14.0f));		

		for (int i=10; i<21; i++)
		{
			System.out.println(i + "pt: " + (font.getAscentPoint(ALPHABET, i) - font.getDescentPoint(ALPHABET, i)));
		}
		
		//FontFactory.register("resources/fonts/new_font.TTF", "new_font");
		System.exit(0);
		
		//------------------------------------------------------------------------
		// Starting Up
		//------------------------------------------------------------------------
		// I think default size is A4.
		//Document document = new Document();
		Document document = new Document(PageSize.LETTER);
		PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(filename));
		document.open();
		
		
		//------------------------------------------------------------------------
		// Text Examples
		//------------------------------------------------------------------------
		// Text Examples
		document.add(new Paragraph("Hello World!"));

		//------------------------------------------------------------------------
		// Line Examples
		//------------------------------------------------------------------------
		PdfContentByte cb = writer.getDirectContent();
		
		// Draw horizontal line in middle of 8.5x11 page. 612x792
		cb.moveTo(72, 792/2);
		cb.lineTo((int)(72*7.5), 792/2);
		cb.stroke();
		
		//cb.saveState();
		cb.setColorStroke(BaseColor.RED);
		cb.setColorFill(BaseColor.BLUE);
		cb.setLineWidth(5.0f);	 // Make a bit thicker than 1.0 default
		cb.rectangle(72,72,144,144);  // Line width is 1/2 in and 1/2 out...
		cb.stroke();
		cb.rectangle(72,72,144,144);
		cb.fill();
		cb.stroke();
		//cb.saveState();

		/*
      cb.setFontAndSize(BaseFont.createFont(BaseFont.HELVETICA, BaseFont.WINANSI, false), 24);
		 */
		
		/*
		Document document = new Document(PageSize.A4, 36, 36, 36, 36);
		PdfWriter writer = PdfWriter.getInstance(document, out);
		PdfContentByte cb = writer.getDirectContent();
		cb.setLineWidth(2.0f);	 // Make a bit thicker than 1.0 default
		cb.setGrayStroke(0.95f); // 1 = black, 0 = white
		float x = 72f;
		float 7 = 72f;
		cb.moveTo(x,         y);
		cb.lineTo(x + 72f*6, y);
		cb.stroke();
		Maybe you want to replace "72f*6" with "PageSize.A4.getWidth() - 72.0" 
		as the above example only gives you a 1 inch horizontal line, 
		set one inch up from origin (south-west corner).
		*/
		
		//------------------------------------------------------------------------
		// Image Examples
		//------------------------------------------------------------------------
		// Bad Quality - but image sucked...
		//Image image = Image.getInstance("C:/Users/Gerhard/AppData/Local/Temp/jibs6163181828984133801.jpg");

		// Quality OK, but GIANT
		Image image = Image.getInstance("d:/trash/a-original.jpg");

		// Fabulous!!
		image.scaleToFit(200, 300);
		image.setAbsolutePosition(10, 400);
		// document.add(image); 

		try
		{
			BufferedImage buffImageFullSize = ImageFactory.getImageFactory()
					.getImageEZ(new File("d:/trash/a-original.jpg"));
			BufferedImage buffImage = ImageChangeUtil.resizeImageDown(
					buffImageFullSize, 200, 300);
			image = Image.getInstance(buffImage, null);
			image.setAbsolutePosition(300, 400);
			//document.add(image);
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}

		// 386k with just first image
		// 539k with both images
		// 154k with just second image

		//------------------------------------------------------------------------
		// Closing down
		//------------------------------------------------------------------------
		
		// Don't forget to close!
		document.close();
		System.out.println("All Done!");
	}

	// ==========================================================================
	//                       Main
	// ==========================================================================
	public static void main(String[] args)
	{
		try
		{
			/** Path to the resulting PDF file. */
			String output = "d:/trash/hello.pdf";
			new ITextDemo().createPdf(output);
			
			Runtime.getRuntime().exec("\"C:/Program Files (x86)/Adobe/Reader 10.0/Reader/AcroRd32.exe\" " + output );
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}

}