/*
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.util;

import java.util.*;

/**
 * From Dr. Heinz Kabutz
 * http://www.javaspecialists.eu/archive/Issue015.html
 * http://archive.devx.com/java/free/articles/Kabutz01/Kabutz01-2.asp
 */

@SuppressWarnings("unchecked")
public class SoftHashMapTest
{
	private static void print(Map<?,?> map)
	{
		System.out.println("One=" + map.get("One"));
		System.out.println("Two=" + map.get("Two"));
		System.out.println("Three=" + map.get("Three"));
		System.out.println("Four=" + map.get("Four"));
		System.out.println("Five=" + map.get("Five"));
	}

	private static void testMap(Map map)
	{
		System.out.println("Testing " + map.getClass());
		map.put("One", new Integer(1));
		map.put("Two", new Integer(2));
		map.put("Three", new Integer(3));
		map.put("Four", new Integer(4));
		map.put("Five", new Integer(5));
		print(map);
		//byte[] block = new byte[10 * 1024 * 1024]; // 10 MB
		print(map);
	}

	public static void main(String[] args)
	{
		testMap(new HashMap());
		testMap(new SoftValueHashMapOLD(2));
	}
}
