package biz.edemocracy;
//By Alex Erawa Viacad
import javax.swing.*;
//import java.awt.TextArea;
// import java.awt.BorderLayout;
// import javax.swing.JTree.*;
// import java.awt.event.KeyEvent;
// import javax.swing.AbstractButton.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;
import java.awt.GridLayout;
import java.awt.BorderLayout;
//import java.awt.event.KeyEvent;
import org.gerhardb.lib.swing.*;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
//import javax.swing.JButton;

import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import java.awt.Toolkit;

public class VotingInterface extends JFrame implements ActionListener
{
	ArrayList<Law> Laws = new ArrayList<Law>();
	//ArrayList<String> Representatives = new ArrayList<String>(); //Alias

	JPanelRows AllRowsOfPanels = new JPanelRows();
	JPanel aRow = AllRowsOfPanels.topRow();

	ArrayList<JToggleButton> sectionButtons = new ArrayList<JToggleButton>();
	ArrayList<JToggleButton> whatUserIsDoingButtons = new ArrayList<JToggleButton>();
	ArrayList<JToggleButton> classButtons = new ArrayList<JToggleButton>();

	ButtonGroup votingSectionButtonGroup = new ButtonGroup();
	ButtonGroup whatUserIsDoingButtonGroup = new ButtonGroup();
	ButtonGroup votingClassificationButtonGroup = new ButtonGroup();

	JPanel tabbedPanel = new JPanel();
	JTabbedPane CriminalTabs = new JTabbedPane();
	JTabbedPane CivilTabs = new JTabbedPane();
	JTabbedPane TaxTabs = new JTabbedPane();
	JTabbedPane IPTabs = new JTabbedPane();
	JTabbedPane MillitaryTabs = new JTabbedPane();
	JTabbedPane TerrorismTabs = new JTabbedPane();
	JTabbedPane GovernmentProjectsTabs = new JTabbedPane();
	JTabbedPane PublicDomainTabs = new JTabbedPane();
	JTabbedPane WorkingsOfDemocracyTabs = new JTabbedPane();

	int section = 6;
	String classification = "Criminal Law";
	String whatUserIsDoing = "Voting";
	int tabIndex = 0;
	String subClassification = "All Criminal Laws";
	String oldClassification = "Criminal Law";
	int oldSection = 6;
	String oldWhatUserIsDoing = "Voting";
	int oldTabIndex = 0;

	ArrayList<JPanel> classificationPanels = new ArrayList<JPanel>();
	JPanel emptyJPanel = new JPanel();

	ImageIcon Icon6 = createImageIcon("6Icon.png");
	ImageIcon Icon5 = createImageIcon("5Icon.png");
	ImageIcon Icon4 = createImageIcon("4Icon.png");
	ImageIcon Icon3 = createImageIcon("3Icon.png");
	ImageIcon Icon2 = createImageIcon("2Icon.png");
	ImageIcon Icon1 = createImageIcon("1Icon.png");
	ImageIcon IconA = createImageIcon("AIcon.png");

	ChangeListener changeListener = new ChangeListener()
	{
		public void stateChanged(ChangeEvent changeEvent)
		{
			JTabbedPane sourceTabbedPane = (JTabbedPane) changeEvent.getSource();
			oldTabIndex = tabIndex;
			tabIndex = sourceTabbedPane.getSelectedIndex();
			subClassification = sourceTabbedPane.getTitleAt(tabIndex);
			//System.out.println("Tab changed to: " + sourceTabbedPane.getTitleAt(tabIndex));
			System.out.println(subClassification);

			if (classification == "Criminal Law")
			{
				classificationPanels.set(oldTabIndex, emptyJPanel);
				classificationPanels.get(tabIndex).add(getMainPanel());
			}
			else if (classification == "Civil Law")
			{
				classificationPanels.set(oldTabIndex + 36, emptyJPanel);
				classificationPanels.get(tabIndex + 36).add(getMainPanel());
			}
			else if (classification == "Tax Law")
			{
				classificationPanels.set(oldTabIndex + 46, emptyJPanel);
				classificationPanels.get(tabIndex + 46).add(getMainPanel());
			}
			else if (classification == "I.P. Law")
			{
				classificationPanels.set(oldTabIndex + 56, emptyJPanel);
				classificationPanels.get(tabIndex + 56).add(getMainPanel());
			}
			else if (classification == "Millitary Law")
			{
				classificationPanels.set(oldTabIndex + 72, emptyJPanel);
				classificationPanels.get(tabIndex + 72).add(getMainPanel());
			}
			else if (classification == "Terrorism Law")
			{
				classificationPanels.set(oldTabIndex + 88, emptyJPanel);
				classificationPanels.get(tabIndex + 88).add(getMainPanel());
			}
			else if (classification == "Government Projects")
			{
				classificationPanels.set(oldTabIndex + 105, emptyJPanel);
				classificationPanels.get(tabIndex + 105).add(getMainPanel());
			}
			else if (classification == "Public Domain Projects")
			{
				classificationPanels.set(oldTabIndex + 124, emptyJPanel);
				classificationPanels.get(tabIndex + 124).add(getMainPanel());
			}
			else if (classification == "Workings of Democracy")
			{
				classificationPanels.set(oldTabIndex + 142, emptyJPanel);
				classificationPanels.get(tabIndex + 142).add(getMainPanel());
			}   
		}
	};

	class Law
	{
		public String classification = "Criminal Law";
		public String subClassification = "All Criminal Laws"; //Change Me Later fdsa
		public String htmlLaw = "<html><body><b>This is a Law's Text. If you see this there is a Problem.</><br>Howdy!</body></html>";
		//Needs Breaks to show a paragraph
		public int positiveVotes = 4;
		public int negitiveVotes = 5;
		int positiveMinusNegitiveVotes = positiveVotes - negitiveVotes;
		int section = 6;
		public char vote = '0'; //The user's vote
		boolean voteChanged = false;

		public ArrayList<JToggleButton> voteButtons = new ArrayList<JToggleButton>();
		public ButtonGroup voteButtonGroup = new ButtonGroup();
	}

	public void addLaws()
	{
		Laws.add(new Law());
		Laws.add(new Law());
		Laws.add(new Law());
		Laws.get(1).subClassification = "Murder";
		Laws.get(2).subClassification = "Arson";
	}

	public VotingInterface()
	{
		super("VotingInterface");
		super.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		//myFrame.setExtendedState(myFrame.getExtendedState()|JFrame.MAXIMIZED_BOTH); //Maximizes Voting Interface Frame
		addLaws();
		super.add(MainButtons());// Add MainButtons to the window and initializes law types tabbedPanes.
		Toolkit tk = Toolkit.getDefaultToolkit();
		int xSize = ((int) tk.getScreenSize().getWidth());  
		//int ySize = ((int) tk.getScreenSize().getHeight());  
		super.setSize(xSize, 600);//old.setSize(1440, 852);

		SwingUtils.centerOnScreen(this);
		super.setVisible(true);
	}

	private JPanel MainButtons()
	{		
		sectionButtons.add(new JToggleButton("<-100", Icon6));
		sectionButtons.add(new JToggleButton("-100 - 100", Icon5));
		sectionButtons.add(new JToggleButton("100-10^5", Icon4));
		sectionButtons.add(new JToggleButton("10^5-10^7", Icon3));
		sectionButtons.add(new JToggleButton("10^7-3.5*10^8", Icon2));
		sectionButtons.add(new JToggleButton("3.5*10^8-10^9", Icon1));
		sectionButtons.add(new JToggleButton("10^9-3.5*10^9", IconA));
		for (JToggleButton aButton : sectionButtons)
		{
			aButton.addActionListener(this);
			aButton.setActionCommand(aButton.getText());
			this.votingSectionButtonGroup.add(aButton);
		}
		sectionButtons.get(0).setSelected(true);

		whatUserIsDoingButtons.add(new JToggleButton("Voting"));
		whatUserIsDoingButtons.add(new JToggleButton("Vote Representation"));
		whatUserIsDoingButtons.add(new JToggleButton("Voting Record"));
		for (JToggleButton aButton : whatUserIsDoingButtons)
		{
			aButton.addActionListener(this);
			aButton.setActionCommand(aButton.getText());
			this.whatUserIsDoingButtonGroup.add(aButton);
		}
		whatUserIsDoingButtons.get(0).setSelected(true);

		classButtons.add(new JToggleButton("Criminal Law"));
		classButtons.add(new JToggleButton("Civil Law"));
		classButtons.add(new JToggleButton("Tax Law"));
		classButtons.add(new JToggleButton("I.P. Law"));
		classButtons.add(new JToggleButton("Millitary Law"));
		classButtons.add(new JToggleButton("Terrorism Law"));
		classButtons.add(new JToggleButton("Government Projects"));
		classButtons.add(new JToggleButton("Public Domain Projects"));
		classButtons.add(new JToggleButton("Workings of Democracy"));
		classButtons.add(new JToggleButton("Forum"));
		for (JToggleButton aButton : classButtons)
		{
			aButton.addActionListener(this);
			aButton.setActionCommand(aButton.getText());
			this.votingClassificationButtonGroup.add(aButton);
		}
		classButtons.get(0).setSelected(true);

		for (int a = 0; a <= 149; a++)
			classificationPanels.add(new JPanel());

		classificationPanels.get(tabIndex).add(getMainPanel());

		CriminalTabs.setTabPlacement(SwingConstants.LEFT);
		CriminalTabs.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);		
		CriminalTabs.addTab("All Criminal Laws", classificationPanels.get(0));
		CriminalTabs.addTab("Murder", classificationPanels.get(1));
		CriminalTabs.addTab("Arson", classificationPanels.get(2));
		CriminalTabs.addTab("Man Slaughter", classificationPanels.get(3));
		CriminalTabs.addTab("Rape", classificationPanels.get(4));
		CriminalTabs.addTab("Child Abuse", classificationPanels.get(5));
		CriminalTabs.addTab("Assault", classificationPanels.get(6));
		CriminalTabs.addTab("Hate Crimes", classificationPanels.get(7));
		CriminalTabs.addTab("Robbery", classificationPanels.get(8));
		CriminalTabs.addTab("Kidnapping", classificationPanels.get(9));
		CriminalTabs.addTab("Extortion", classificationPanels.get(10));
		CriminalTabs.addTab("Mob/Gang Laws", classificationPanels.get(11));
		CriminalTabs.addTab("PyramidSchemes", classificationPanels.get(12));
		CriminalTabs.addTab("Embezzlement", classificationPanels.get(13));
		CriminalTabs.addTab("Wire Fraud", classificationPanels.get(14));
		CriminalTabs.addTab("Abetting", classificationPanels.get(15));
		CriminalTabs.addTab("Larsony", classificationPanels.get(16));
		CriminalTabs.addTab("Trespassing", classificationPanels.get(17));
		CriminalTabs.addTab("Neglect", classificationPanels.get(18));
		CriminalTabs.addTab("Cyber Laws", classificationPanels.get(19));
		CriminalTabs.addTab("Solicitation", classificationPanels.get(20));
		CriminalTabs.addTab("Perjury", classificationPanels.get(21));
		CriminalTabs.addTab("White Collar Laws", classificationPanels.get(22));
		CriminalTabs.addTab("Distirbing Peace", classificationPanels.get(23));
		CriminalTabs.addTab("Probation Laws", classificationPanels.get(24));
		CriminalTabs.addTab("Drug Laws", classificationPanels.get(25));
		CriminalTabs.addTab("Bribery", classificationPanels.get(26));
		CriminalTabs.addTab("Mental Health", classificationPanels.get(27));
		CriminalTabs.addTab("Stalking", classificationPanels.get(28));
		CriminalTabs.addTab("Alcohol+Tobacco", classificationPanels.get(29));
		CriminalTabs.addTab("Vehicle Laws", classificationPanels.get(30));
		CriminalTabs.addTab("Tax Evasion", classificationPanels.get(31));
		CriminalTabs.addTab("DisorderlyConduct", classificationPanels.get(32));
		CriminalTabs.addTab("Statutory Rape", classificationPanels.get(33));
		CriminalTabs.addTab("Child Porno", classificationPanels.get(34));
		CriminalTabs.addTab("Other", classificationPanels.get(35));
		classificationPanels.get(35).setPreferredSize(new Dimension(1000, 1000));
		CriminalTabs.addChangeListener(changeListener);

		CivilTabs.setTabPlacement(SwingConstants.LEFT);
		CivilTabs.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
		CivilTabs.addTab("All Civil Laws", classificationPanels.get(36));
		CivilTabs.addTab("Property Disputes", classificationPanels.get(37));
		CivilTabs.addTab("Divorce Law", classificationPanels.get(38));
		CivilTabs.addTab("Child Custody", classificationPanels.get(39));
		CivilTabs.addTab("Breach of Contract", classificationPanels.get(40));
		CivilTabs.addTab("Personal Injury", classificationPanels.get(41));
		CivilTabs.addTab("Negligence", classificationPanels.get(42));
		CivilTabs.addTab("Gay/LesbianMarrige", classificationPanels.get(43));
		CivilTabs.addTab("PolygamousMarrige", classificationPanels.get(44));
		CivilTabs.addTab("Other", classificationPanels.get(45));
		classificationPanels.get(45).setPreferredSize(new Dimension(1000, 1000));
		CivilTabs.addChangeListener(changeListener);

		TaxTabs.setTabPlacement(SwingConstants.LEFT);
		TaxTabs.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
		TaxTabs.addTab("All Tax Laws", classificationPanels.get(46));
		TaxTabs.addTab("Pork Taxes", classificationPanels.get(47));
		TaxTabs.addTab("EnviromentalImpactTaxes", classificationPanels.get(48));
		TaxTabs.addTab("Captial Gains Taxes", classificationPanels.get(49));
		TaxTabs.addTab("Corpirate Taxes", classificationPanels.get(50));
		TaxTabs.addTab("Tarifs", classificationPanels.get(51));
		TaxTabs.addTab("Sales Taxes", classificationPanels.get(52));
		TaxTabs.addTab("Property Taxes", classificationPanels.get(53));
		TaxTabs.addTab("Income Taxes", classificationPanels.get(54));
		TaxTabs.addTab("Other Types Of Taxes", classificationPanels.get(55));
		classificationPanels.get(55).setPreferredSize(new Dimension(1000, 1000));
		TaxTabs.addChangeListener(changeListener);

		IPTabs.setTabPlacement(SwingConstants.LEFT);
		IPTabs.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
		IPTabs.addTab("AllIntelProperyRights", classificationPanels.get(56));
		IPTabs.addTab("Music", classificationPanels.get(57));
		IPTabs.addTab("TV Shows", classificationPanels.get(58));
		IPTabs.addTab("Movies", classificationPanels.get(59));
		IPTabs.addTab("Other Videos", classificationPanels.get(60));
		IPTabs.addTab("Video Games", classificationPanels.get(61));
		IPTabs.addTab("Application Software", classificationPanels.get(62));
		IPTabs.addTab("E-Books", classificationPanels.get(63));
		IPTabs.addTab("Other Things Stealable", classificationPanels.get(64));
		IPTabs.addTab("Hardware Patent Law", classificationPanels.get(65));
		IPTabs.addTab("Software Patent Law", classificationPanels.get(66));
		IPTabs.addTab("Design Patent Law", classificationPanels.get(67));
		IPTabs.addTab("Plant Patent Law", classificationPanels.get(68));
		IPTabs.addTab("Domain Name Law", classificationPanels.get(69));
		IPTabs.addTab("Trademark Law", classificationPanels.get(70));
		IPTabs.addTab("OtherIntelPropertyLaw", classificationPanels.get(71));
		classificationPanels.get(71).setPreferredSize(new Dimension(1000, 1000));
		IPTabs.addChangeListener(changeListener);

		MillitaryTabs.setTabPlacement(SwingConstants.LEFT);
		MillitaryTabs.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
		MillitaryTabs.addTab("All Millitary Laws", classificationPanels.get(72));
		MillitaryTabs.addTab("High Treason", classificationPanels.get(73));
		MillitaryTabs.addTab("Treason", classificationPanels.get(74));
		MillitaryTabs.addTab("Sedition", classificationPanels.get(75));
		MillitaryTabs.addTab("Spying", classificationPanels.get(76));
		MillitaryTabs.addTab("Laws About Decisions", classificationPanels.get(77));
		MillitaryTabs.addTab("Murder in the Field", classificationPanels.get(78));
		MillitaryTabs.addTab("Mil. Criminal Acts", classificationPanels.get(79));
		MillitaryTabs.addTab("Friendly Fire Laws", classificationPanels.get(80));
		MillitaryTabs.addTab("FailureToFollowOrders", classificationPanels.get(81));
		MillitaryTabs.addTab("Refusing To Fight", classificationPanels.get(82));
		MillitaryTabs.addTab("Rules Of Engagment", classificationPanels.get(83));
		MillitaryTabs.addTab("WhetherWarIsFought", classificationPanels.get(84));
		MillitaryTabs.addTab("Court Marshal Rules", classificationPanels.get(85));
		MillitaryTabs.addTab("ClandestineMil.Acts", classificationPanels.get(86));
		MillitaryTabs.addTab("Other Millitary Laws", classificationPanels.get(87));
		classificationPanels.get(87).setPreferredSize(new Dimension(1000, 1000));
		MillitaryTabs.addChangeListener(changeListener);

		TerrorismTabs.setTabPlacement(SwingConstants.LEFT);
		TerrorismTabs.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
		TerrorismTabs.addTab("All Terrorism Laws", classificationPanels.get(88));
		TerrorismTabs.addTab("Nuclear Terrorism", classificationPanels.get(89));
		TerrorismTabs.addTab("Viral Terrorism", classificationPanels.get(90));
		TerrorismTabs.addTab("Bacterial Terrorism", classificationPanels.get(91));
		TerrorismTabs.addTab("Dirty Bomb Terrorism", classificationPanels.get(92));
		TerrorismTabs.addTab("Explosive Terrorism", classificationPanels.get(93));
		TerrorismTabs.addTab("Assination Terrorism", classificationPanels.get(94));
		TerrorismTabs.addTab("Hacking Terrorism", classificationPanels.get(95));
		TerrorismTabs.addTab("Ecoterrorism", classificationPanels.get(96));
		TerrorismTabs.addTab("Terrorist Threats", classificationPanels.get(97));
		TerrorismTabs.addTab("Other Terrorism Laws", classificationPanels.get(98));
		TerrorismTabs.addTab("Monitoring Rights", classificationPanels.get(99));
		TerrorismTabs.addTab("Detaining Rights", classificationPanels.get(100));
		TerrorismTabs.addTab("Searching Rights", classificationPanels.get(101));
		TerrorismTabs.addTab("Seizing Rights", classificationPanels.get(102));
		TerrorismTabs.addTab("MonitarySeizingRights", classificationPanels.get(103));
		TerrorismTabs.addTab("Other Counterterroism", classificationPanels.get(104));
		classificationPanels.get(104).setPreferredSize(new Dimension(1000, 1000));
		TerrorismTabs.addChangeListener(changeListener);

		GovernmentProjectsTabs.setTabPlacement(SwingConstants.LEFT);
		GovernmentProjectsTabs.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
		GovernmentProjectsTabs.addTab("All Services & Projects", classificationPanels.get(105));
		GovernmentProjectsTabs.addTab("Health Care", classificationPanels.get(106));
		GovernmentProjectsTabs.addTab("Education", classificationPanels.get(107));
		GovernmentProjectsTabs.addTab("Social Securities", classificationPanels.get(108));
		GovernmentProjectsTabs.addTab("Welfare", classificationPanels.get(109));
		GovernmentProjectsTabs.addTab("ServicesForMillitaryPersonel", classificationPanels.get(110));
		GovernmentProjectsTabs.addTab("Other Government Services", classificationPanels.get(111));
		GovernmentProjectsTabs.addTab("Road And Bridge Projects", classificationPanels.get(112));
		GovernmentProjectsTabs.addTab("Schools", classificationPanels.get(113));
		GovernmentProjectsTabs.addTab("Universities", classificationPanels.get(114));
		GovernmentProjectsTabs.addTab("Libraries", classificationPanels.get(115));
		GovernmentProjectsTabs.addTab("Museums", classificationPanels.get(116));
		GovernmentProjectsTabs.addTab("Hospitals And Clinics", classificationPanels.get(117));
		GovernmentProjectsTabs.addTab("Post Offices", classificationPanels.get(118));
		GovernmentProjectsTabs.addTab("Government Service Buildings", classificationPanels.get(119));
		GovernmentProjectsTabs.addTab("Governing Buildings", classificationPanels.get(120));
		GovernmentProjectsTabs.addTab("Millitary Projects", classificationPanels.get(121));
		GovernmentProjectsTabs.addTab("Space Program", classificationPanels.get(122));
		GovernmentProjectsTabs.addTab("Other Government Projects", classificationPanels.get(123));
		classificationPanels.get(123).setPreferredSize(new Dimension(1000, 1000));
		GovernmentProjectsTabs.addChangeListener(changeListener);

		PublicDomainTabs.setTabPlacement(SwingConstants.LEFT);
		PublicDomainTabs.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
		PublicDomainTabs.addTab("All Public Domain Laws", classificationPanels.get(124));
		PublicDomainTabs.addTab("Light Residential Projects", classificationPanels.get(125));
		PublicDomainTabs.addTab("Light Commercial Projects", classificationPanels.get(126));
		PublicDomainTabs.addTab("Light Industrial Projects", classificationPanels.get(127));
		PublicDomainTabs.addTab("Light Agricultural Projects", classificationPanels.get(128));
		PublicDomainTabs.addTab("Ligh Recreational Projects", classificationPanels.get(129));
		PublicDomainTabs.addTab("Medium Residential Projects", classificationPanels.get(130));
		PublicDomainTabs.addTab("MediumCommercialProjects", classificationPanels.get(131));
		PublicDomainTabs.addTab("Medium Industrial Projects", classificationPanels.get(132));
		PublicDomainTabs.addTab("MediumRecreationalProjects", classificationPanels.get(133));
		PublicDomainTabs.addTab("Dense Residential Projects", classificationPanels.get(134));
		PublicDomainTabs.addTab("Dense Commercial Projects", classificationPanels.get(135));
		PublicDomainTabs.addTab("Dense Industrial Projects", classificationPanels.get(136));
		PublicDomainTabs.addTab("DenseRecreationalProjects", classificationPanels.get(137));
		PublicDomainTabs.addTab("Light Zoning Laws", classificationPanels.get(138));
		PublicDomainTabs.addTab("Medium Zoning Laws", classificationPanels.get(139));
		PublicDomainTabs.addTab("Dense Zoning Laws", classificationPanels.get(140));
		PublicDomainTabs.addTab("General Public Domain Laws", classificationPanels.get(141));
		classificationPanels.get(141).setPreferredSize(new Dimension(1000, 1000));
		PublicDomainTabs.addChangeListener(changeListener);

		WorkingsOfDemocracyTabs.setTabPlacement(SwingConstants.LEFT);
		WorkingsOfDemocracyTabs.setTabLayoutPolicy(JTabbedPane.SCROLL_TAB_LAYOUT);
		WorkingsOfDemocracyTabs.addTab("All Laws What So Ever", classificationPanels.get(142));
		WorkingsOfDemocracyTabs.addTab("AllE-Dem.WorkingsLaws", classificationPanels.get(143));
		WorkingsOfDemocracyTabs.addTab("StructureOfTheGoverment", classificationPanels.get(144));
		WorkingsOfDemocracyTabs.addTab("Powers Of E-Legislative", classificationPanels.get(145));
		WorkingsOfDemocracyTabs.addTab("Powers Of The Exuctive", classificationPanels.get(146));
		WorkingsOfDemocracyTabs.addTab("Powers Of The Judicial", classificationPanels.get(147));
		WorkingsOfDemocracyTabs.addTab("WaysToImprove E-Dem.biz", classificationPanels.get(148));
		WorkingsOfDemocracyTabs.addTab("Other Gov. Working Laws", classificationPanels.get(149));
		classificationPanels.get(149).setPreferredSize(new Dimension(1000, 1000));
		WorkingsOfDemocracyTabs.addChangeListener(changeListener);

		//Implements a Program Specific Function to display multiple rows in this case.
		aRow.add(new JLabel("Voting Section: "));
		for (JToggleButton aButton : sectionButtons)
		{
			aRow.add(aButton);
		}

		aRow.add(new JLabel("|"));

		for (JToggleButton aButton : whatUserIsDoingButtons)
		{
			aRow.add(aButton);
		}

		aRow = AllRowsOfPanels.nextRow();
		aRow.add(new JLabel("Voting Classification: "));
		for (JToggleButton aButton : classButtons)
		{
			aRow.add(aButton);
		}
		tabbedPanel = AllRowsOfPanels.nextRow();
		tabbedPanel.add(CriminalTabs);

		return AllRowsOfPanels;
	}

	@Override
	public void actionPerformed(ActionEvent event)
	{
		Object source = event.getSource();
		if (source instanceof JToggleButton)
		{
			oldClassification = classification;
			oldSection = section;
			oldWhatUserIsDoing = whatUserIsDoing;
			//oldVote = vote;
			String sectionText = this.votingSectionButtonGroup.getSelection().getActionCommand();
			if (sectionText == "<-100")			
				section = 6;
			else if (sectionText == "-100 - 100")
				section = 5;
			else if (sectionText == "100-10^5")
				section = 4;
			else if (sectionText == "10^5-10^7")
				section = 3;
			else if (sectionText == "10^7-3.5*10^8")
				section = 2;
			else if (sectionText == "3.5*10^8-10^9")
				section = 1;
			else if (sectionText == "10^9-3.5*10^9")
				section = 0;

			classification = this.votingClassificationButtonGroup.getSelection().getActionCommand();
			whatUserIsDoing = this.whatUserIsDoingButtonGroup.getSelection().getActionCommand();
			//Laws.get(0).vote = voteButtonGroup.getSelection().getActionCommand(); //asdf fdsa

			//System.out.println (classification);
			//System.out.println ("OldTI" + oldTabIndex);
			//System.out.println ("TI" + tabIndex);

			if (classification != oldClassification)
			{
				oldTabIndex = tabIndex;
				if (oldClassification == "Criminal Law")
					classificationPanels.set(oldTabIndex, emptyJPanel);
				else if (oldClassification == "Civil Law")
					classificationPanels.set(oldTabIndex + 36, emptyJPanel);
				else if (oldClassification == "Tax Law")
					classificationPanels.set(oldTabIndex + 46, emptyJPanel);
				else if (oldClassification == "I.P. Law")
					classificationPanels.set(oldTabIndex + 56, emptyJPanel);
				else if (oldClassification == "Millitary Law")
					classificationPanels.set(oldTabIndex + 72, emptyJPanel);
				else if (oldClassification == "Terrorism Law")
					classificationPanels.set(oldTabIndex + 88, emptyJPanel);
				else if (oldClassification == "Government Projects")
					classificationPanels.set(oldTabIndex + 105, emptyJPanel);
				else if (oldClassification == "Public Domain Projects")
					classificationPanels.set(oldTabIndex + 124, emptyJPanel);
				else if (oldClassification == "Workings of Democracy")
					classificationPanels.set(oldTabIndex + 142, emptyJPanel);

				if (classification == "Criminal Law")
				{
					tabIndex = CriminalTabs.getSelectedIndex();
					classificationPanels.get(tabIndex).add(getMainPanel());
					tabbedPanel.removeAll();
					tabbedPanel.setVisible(false);
					tabbedPanel.add(CriminalTabs);
					tabbedPanel.setVisible(true);
					tabbedPanel.revalidate();
				}
				else if (classification == "Civil Law")
				{
					tabIndex = CivilTabs.getSelectedIndex();
					classificationPanels.get(tabIndex + 36).add(getMainPanel());
					tabbedPanel.removeAll();
					tabbedPanel.setVisible(false);
					tabbedPanel.add(CivilTabs);
					tabbedPanel.setVisible(true);
					tabbedPanel.revalidate();
				}
				else if (classification == "Tax Law")
				{
					tabIndex = TaxTabs.getSelectedIndex();
					classificationPanels.get(tabIndex + 46).add(getMainPanel());
					tabbedPanel.removeAll();
					tabbedPanel.setVisible(false);
					tabbedPanel.add(TaxTabs);
					tabbedPanel.setVisible(true);
					tabbedPanel.revalidate();
				}
				else if (classification == "I.P. Law")
				{
					tabIndex = IPTabs.getSelectedIndex();
					classificationPanels.get(tabIndex + 56).add(getMainPanel());
					tabbedPanel.removeAll();
					tabbedPanel.setVisible(false);
					tabbedPanel.add(IPTabs);
					tabbedPanel.setVisible(true);
					tabbedPanel.revalidate();
				}
				else if (classification == "Millitary Law")
				{
					tabIndex = MillitaryTabs.getSelectedIndex();
					classificationPanels.get(tabIndex + 72).add(getMainPanel());
					tabbedPanel.removeAll();
					tabbedPanel.setVisible(false);
					tabbedPanel.add(MillitaryTabs);
					tabbedPanel.setVisible(true);
					tabbedPanel.revalidate();
				}
				else if (classification == "Terrorism Law")
				{
					tabIndex = TerrorismTabs.getSelectedIndex();
					classificationPanels.get(tabIndex + 88).add(getMainPanel());
					tabbedPanel.removeAll();
					tabbedPanel.setVisible(false);
					tabbedPanel.add(TerrorismTabs);
					tabbedPanel.setVisible(true);
					tabbedPanel.revalidate();
				}
				else if (classification == "Government Projects")
				{
					tabIndex = GovernmentProjectsTabs.getSelectedIndex();
					classificationPanels.get(tabIndex + 105).add(getMainPanel());
					tabbedPanel.removeAll();
					tabbedPanel.setVisible(false);
					tabbedPanel.add(GovernmentProjectsTabs);
					tabbedPanel.setVisible(true);
					tabbedPanel.revalidate();
				}
				else if (classification == "Public Domain Projects")
				{
					tabIndex = PublicDomainTabs.getSelectedIndex();
					classificationPanels.get(tabIndex + 124).add(getMainPanel());
					tabbedPanel.removeAll();
					tabbedPanel.setVisible(false);
					tabbedPanel.add(PublicDomainTabs);
					tabbedPanel.setVisible(true);
					tabbedPanel.revalidate();
				}
				else if (classification == "Workings of Democracy")
				{
					tabIndex = WorkingsOfDemocracyTabs.getSelectedIndex();
					classificationPanels.get(tabIndex + 142).add(getMainPanel());
					tabbedPanel.removeAll();
					tabbedPanel.setVisible(false);
					tabbedPanel.add(WorkingsOfDemocracyTabs);
					tabbedPanel.setVisible(true);
					tabbedPanel.revalidate();
				}
				else if (classification == "Forum")
				{
					tabbedPanel.removeAll();
					tabbedPanel.setVisible(false);
					tabbedPanel.revalidate();
				}	
			}
		}
	}

	private JPanel getMainPanel()
	{
		
		JPanel votingPanel = new JPanel();

		JPanelRows theLayout = new JPanelRows();
		JPanel mainPanel = theLayout.nextRow(new BorderLayout());
		
		JEditorPane editorPane = new JEditorPane();
		editorPane.setEditable(false);
		editorPane.setDisabledTextColor(Color.black);
		// javax.swing.JEditorPane.  Current types are:  "text/plain", "text/html", "text/rtf"
		editorPane.setEditorKit(
				JEditorPane.createEditorKitForContentType("text/html"));
		JScrollPane scrollingEditor = new JScrollPane(
				editorPane,
				ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,
				ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
				);

		JList leftList = new JList();
		DefaultListModel listContents = new DefaultListModel();
		leftList.setModel(listContents);
		
		editorPane.setText(Laws.get(0).htmlLaw);

		mainPanel.add(leftList, BorderLayout.WEST);
		mainPanel.add(scrollingEditor, BorderLayout.CENTER);
		mainPanel.add(votingPanel, BorderLayout.EAST);	

		for (Law aLaw : Laws)
		{	
			if (aLaw.voteButtons.isEmpty() == true)
			{
				aLaw.voteButtons.add(new JToggleButton("+"));
				aLaw.voteButtons.add(new JToggleButton("0"));
				aLaw.voteButtons.add(new JToggleButton("-"));
				for (JToggleButton aButton : aLaw.voteButtons)
				{
					aButton.addActionListener(this);
					aButton.setActionCommand(aButton.getText());
					aLaw.voteButtonGroup.add(aButton);
				}
				aLaw.voteButtons.get(1).setSelected(true);
			}
			
			if (aLaw.section == section && aLaw.classification == classification && aLaw.subClassification == subClassification)
			{
				if (aLaw.vote == '0')//asdf
					aLaw.voteButtons.get(1).setSelected(true);
				else if (aLaw.vote == '-')
					aLaw.voteButtons.get(0).setSelected(true);
				else
					aLaw.voteButtons.get(2).setSelected(true);

				for (JToggleButton aButton : aLaw.voteButtons)
				{
					votingPanel.add(aButton);
				}
				aLaw.vote = aLaw.voteButtonGroup.getSelection().getActionCommand().charAt(0);
				System.out.println(aLaw.vote);
			}
		}

		return theLayout;
	}

	protected JComponent makeTextPanel(String text)
	{
		JPanel panel = new JPanel(false);
		JLabel filler = new JLabel(text);
		filler.setHorizontalAlignment(SwingConstants.CENTER);
		panel.setLayout(new GridLayout(1, 1));
		panel.add(filler);
		return panel;
	}

	/** Returns an ImageIcon, or null if the path was invalid. */
	protected static ImageIcon createImageIcon(String path)
	{
		java.net.URL imgURL = VotingInterface.class.getResource(path);
		if (imgURL != null)
		{
			return new ImageIcon(imgURL);
		}
		else
		{
			System.err.println("Couldn't find file: " + path);
			return null;
		}
	}

	public static void main(String[] args)
	{	    
		// Schedule a job for the event dispatch thread:
		// creating and showing this application's GUI.
		SwingUtilities.invokeLater(new Runnable()
		{
			public void run()
			{
				// Turn off metal's use of bold fonts
				UIManager.put("swing.boldMetal", Boolean.FALSE);
				new VotingInterface();
			}
		});
	}
}