/**
 * ****************************************************************************
 *
 * Classification: UNCLASSIFIED
 *
 * $Header: /cvsroot/img-browse-sort/AppStarter-swing/com/saic/isd/printscreen/Util.java,v 1.6 2006/09/30 22:42:38 gerhardb Exp $
 *
 * SAIC (C) Copyright 2004 Science Applications International Corporation.
 * All Rights Reserved.
 *
 * Developed by Science Applications International Corporation under
 * contract to the Department of Defense. All government restrictions
 * on software distribution apply.
 *
 * Subject to the GNU LESSER GENERAL PUBLIC LICENSE,
 * Version 2.1, February 1999 http://www.gnu.org/copyleft/lesser.html
 * A copy of that license is included with the source distribution.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Peer Reviewed:
 * ?? ??? 2003 by ??????
 * ****************************************************************************
 */
package com.saic.isd.printscreen;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

//import org.gerhardb.AppStarter.AppStarter;
import org.gerhardb.lib.print.PrintableText;
import org.gerhardb.lib.util.startup.AppStarter;

import com.saic.isd.swing.filechooser.SimpleFileFilter;

/**
 * Provides a variety of static functions to support the print screen package.
 */
public class Util
{
   /**
    * Sends an HTML string to the printer.  Dialog boxes will come up to get
    * appropriate printer information.
    * <p>
    * @param printMe String containing a complete HTML 3.2 document.
    */
   public static void printHtml( String printMe )  // NO_UCD
   {
      print( printMe, new HTMLEditorKit() );
   }

   public static void previewHTML( Component owner, String title,
                                   String printMe )
   {
      if ( title == null )
      {
         title = AppStarter.getString("print.preview"); //$NON-NLS-1$
      }
      if ( owner instanceof Frame )
      {
         preview(
             new JDialog( ( Frame )owner, title, false ),
             printMe,
             new HTMLEditorKit() );
      }
      else if ( owner instanceof Dialog )
      {
         preview(
             new JDialog( ( Dialog )owner, title, false ),
             printMe,
             new HTMLEditorKit() );
      }
      else
      {
         preview(
             new JDialog( ( Dialog )null, title, false ),
             printMe,
             new HTMLEditorKit() );
      }
   }

   /**
    * Sends a plain text string to the printer.  Dialog boxes will come up to get
    * appropriate printer information.
    * <p>
    * @param printMe Unformatted text string.
    */
   public static void printText( String printMe )  // NO_UCD
   {
      print( printMe, new StyledEditorKit() );
   }

   public static void previewText( Component owner, String title, String printMe )  // NO_UCD
   {
      if ( title == null )
      {
         title = AppStarter.getString("print.preview"); //$NON-NLS-1$
      }
      if ( owner instanceof Frame )
      {
         preview(
             new JDialog( ( Frame )owner, title, false ),
             printMe,
             new StyledEditorKit() );
      }
      else if ( owner instanceof Dialog )
      {
         preview(
             new JDialog( ( Dialog )owner, title, false ),
             printMe,
             new StyledEditorKit() );
      }
      else
      {
         preview(
             null,
             printMe,
             new StyledEditorKit() );
      }
   }

   public static void preview(
       JDialog dialog,
       String printMe,
       javax.swing.text.EditorKit kit )
   {
      final JDialog previewDlg = dialog;
      JEditorPane pane = new JEditorPane();
      pane.setEditorKit( kit );
      pane.setText( printMe );
      pane.validate();
      pane.setEditable( false );
      //pane.addHyperlinkListener( new Hyperactive() );
      final String prtThis = printMe;
      final javax.swing.text.EditorKit theKit = kit;
      JButton okBtn = new JButton( AppStarter.getString("print") ); //$NON-NLS-1$
      okBtn.addActionListener
          (
          new java.awt.event.ActionListener()
      {
         public void actionPerformed( java.awt.event.ActionEvent ae )
         {
            print( prtThis, theKit );
         }
      }
      );
      JButton cancelBtn = new JButton( AppStarter.getString("cancel") ); //$NON-NLS-1$
      cancelBtn.addActionListener
          (
          new java.awt.event.ActionListener()
      {
         public void actionPerformed( java.awt.event.ActionEvent ae )
         {
            previewDlg.dispose();
         }
      }
      );
      JPanel btnPanel = new JPanel( new FlowLayout( FlowLayout.CENTER ) );
      btnPanel.add( okBtn );

      btnPanel.add( cancelBtn );
      Container contentPane = previewDlg.getContentPane();
      contentPane.setLayout( new BorderLayout() );
      contentPane.add( new JScrollPane( pane ), BorderLayout.CENTER );
      contentPane.add( btnPanel, BorderLayout.SOUTH );
      previewDlg.setSize( 800, 600 );
      previewDlg.setVisible(true);
   }

   /**
    * Sends a string to the printer using the editor kit provided.
    * Dialog boxes will come up to get
    * appropriate printer information.
    * <p>
    * Note that if you pass in a DefaultEditorKit, it likely that nothing
    * will print.  Instead, use a StyledEditorKit or HTMLEditorKit.
    * @param printMe text to print
    * @param kit how to print
    */
   public static void print(
       String printMe,
       javax.swing.text.EditorKit kit )
   {
      JEditorPane pane = new JEditorPane();
      pane.setEditorKit( kit );
      pane.setText( printMe );
      pane.validate();
      PrintableText pt = new PrintableText( pane );
      pt.printContent();
   }

   /**
    * Converts String to HTMLDocument.
    * @param convertMe text to convert
    * @return the document
    * @throws java.io.IOException
    * @throws javax.swing.text.BadLocationException
    */
   public static HTMLDocument getHTMLDocument( String convertMe ) // NO_UCD
       throws java.io.IOException, javax.swing.text.BadLocationException
   {
      StringReader reader = new StringReader( convertMe );
      HTMLEditorKit kit = new HTMLEditorKit();
      HTMLDocument rtnMe = ( HTMLDocument )kit.createDefaultDocument();
      kit.read( reader, rtnMe, 0 );
      return rtnMe;
   }

   /**
    * Converts String to InputStream.
    * @param convertMe String to convert
    * @return input stream
    */
   public static InputStream stringToInputStream( String convertMe )  // NO_UCD
   {
      // Other way would be to wrap the a StringRead as a InputStream.
      byte[] bytes = null;
      try
      {
         bytes = convertMe.getBytes( "UTF-8" ); //$NON-NLS-1$
      }
      catch ( java.io.UnsupportedEncodingException ex )
      {
         // We know it ain't gonna happen!
         ex.printStackTrace();
      }
      return new ByteArrayInputStream( bytes );
   }

   /**
    * Gets a string from a file.
    * @param file File to get text from.
    * @return text from the file.
    * @throws FileNotFoundException
    * @throws IOException
    */
   public static String getTextFromFile( File file )
       throws FileNotFoundException, IOException
   {
      BufferedReader buffRead =
          new BufferedReader( new FileReader( file ) );
      StringBuffer buff = new StringBuffer( 5000 );
      String appendMe = buffRead.readLine();
      while ( appendMe != null )
      {
         buff.append( appendMe + "\n" ); //$NON-NLS-1$
         appendMe = buffRead.readLine();
      }
      String html = buff.toString();
      return html;
   }

   /**
    * Writes a String to a file.
    */
   /**
    * Writes a String to a file.
    * @param file file to write to.
    * @param write text to write.
    * @throws IOException
    */
   public static void writeTextToFile( File file, String write )
       throws IOException
   {
      PrintWriter writer =
          new PrintWriter(
          new BufferedWriter(
          new FileWriter( file ) ) );
      writer.print( write );
      writer.flush();
      writer.close();
   }

   /**
    * Returns a data directory for this user for saving stuff into.
    * @return Users home directory.
    */
   public static File getUserHomeDirectory()
   {
      StringBuffer buf = new StringBuffer( 80 );
      buf.append( System.getProperty( "user.home" ) ); //$NON-NLS-1$
      buf.append( File.separator );
      buf.append( "data" ); //$NON-NLS-1$
      File rtnMe = new File( buf.toString() );
      if ( !rtnMe.exists() )
      {
         rtnMe.mkdirs();
      }
      else if ( rtnMe.isFile() )
      {
         rtnMe = rtnMe.getParentFile();
      }
      return rtnMe;
   }

   /**
    * Copies a string to the clip board.
    * @param contents
    */
   public static void copyToClipboard(String contents)
   {
      StringSelection clip = new StringSelection( contents );
      Clipboard clipboard = new JLabel().getToolkit().getSystemClipboard();
      clipboard.setContents( clip, clip );
   }

   /**
    * Asks the user a file name and saves a string to a file.
    * @param contents What to save into the file.
    * @param filter Files to show; file type to be saved.
    * @param window Popup parent. Null allowed.
    */
   public static void saveToFile(
       String contents,
       SimpleFileFilter filter,
       Component component)
   {
      JFileChooser chooser = new JFileChooser( Util.getUserHomeDirectory() );
      chooser.addChoosableFileFilter( filter );
      chooser.setFileFilter( filter );
      int returnVal = chooser.showSaveDialog( component );
      if ( returnVal == JFileChooser.APPROVE_OPTION )
      {
         File file = filter.attachExtension( chooser.getSelectedFile() );
         try
         {
            FileWriter stream = new FileWriter( file );
            stream.write( contents );
            stream.close();
         }
         catch ( IOException ex )
         {
            JOptionPane.showMessageDialog(
                component,
                ex.getMessage(),
                AppStarter.getString("problem"), //$NON-NLS-1$
                JOptionPane.ERROR_MESSAGE );
         }
      }
   }

   // =========================================================================
   //                        Main
   // =========================================================================
   /*
   public static void main( String[] args )
   {
      try
      {
         String printMe =
             Util.getTextFromFile( new File( "c:/gbroot/index.html" ) );
         System.out.println( printMe );
         System.out.println(
             "*************************************************" );
         //Util.printHtml( printMe );
         Util.previewHTML( null, null, printMe );
      }
      catch ( Exception ex )
      {
         ex.printStackTrace();
      }
   }
   */
}
