/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.jibs;

import org.gerhardb.jibs.viewer.frame.SortScreen;
import org.gerhardb.lib.util.startup.AppStarter;

/**
 * Provides a single source of entry to be called from the Jar file. Picks the
 * appropriate application to start based on passed-in parameters.
 * 
 * -props D:\dev\workspaces\JIBS\bin\jibs.props
 * -thumbdrive
 * 
 * Thumbdrive takes precedence.
 */
public class Jibs
{
	private Jibs()
	{
		// Prevent public creation.
	}
	
	public static String getString(String key)
	{
		return AppStarter.getString(key);
	}
	
	// ==========================================================================
	// MAIN
	// ==========================================================================
	public static void main(String[] args)
	{
		System.out.println("JIBS starting with main(): Jibs");
		
		// "org.gerhardb.jibs.Jibs" is correct for bundleName,
		// it gets expanded out to: org.gerhardb.jibs.Jibs.properties
		// or whatever the locale version is (DE for Germany etc.)
		// null is for backward compatibility - jibs orginally didn't have app specificat prefs.
		AppStarter.startUpApp(args, "org.gerhardb.jibs.Jibs", true);
		
		// Make sure we have nice window decorations.
		// THIS CAUSES FULL SCREEN TO HAVE MIN, MAX BUTTONS
		// THEREFORE DON'T setDefaultLookAndFeelDecorated(true)
		// javax.swing.JFrame.setDefaultLookAndFeelDecorated(true);
		new SortScreen();	
	}
}
