package org.gerhardb.jibs.camera;

/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.io.DirListController;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;

/**
 * User interface for the Camera.
 */
public class Camera
   extends JFrame
{
	public static String APP_NAME = "Camera";
   boolean iExitOnClose;

   DirListController myWorkingList =
      new DirListController("Camera", "Camera", false, APP_NAME); //$NON-NLS-2$

   //===========================================================================
   //                          Constructor
   //===========================================================================

   public Camera(boolean exitOnClose)
   {
     init(exitOnClose);
   }

   void init(boolean exitOnClose)
   {
      this.iExitOnClose = exitOnClose;
      setTitle(Jibs.getString("Camera.2")); //$NON-NLS-1$

      addWindowListener(
         new WindowAdapter()
      {
         @Override
			public void windowClosing(WindowEvent e)
         {
            exit();
         }
      }
      );

      enableEvents(AWTEvent.WINDOW_EVENT_MASK);
      try
      {
          //initMenuAndToolbar();
         layoutComponents();
      }
      catch (Exception e)
      {
         e.printStackTrace();
         System.out.println("*** Unkonwn abnormal termination ***");  //$NON-NLS-1$
         System.exit(99);
      }

		this.setIconImage(Icons.getIcon(Icons.JIBS_16).getImage());
      
      // Work on showing the frame!
      EventQueue.invokeLater(new Runnable()
      {
         public void run()
         {
            Camera.this.validate();
            Camera.this.pack();
            SwingUtils.centerOnScreen(Camera.this);
            Camera.this.setVisible(true);
         }
      });

   }

   //===========================================================================
   //                          Component Layout
   //===========================================================================
   private void layoutComponents()
      throws Exception
   {

      // Set up center panel
      JTabbedPane jTabbed = new JTabbedPane();
      jTabbed.addTab(Jibs.getString("Camera.4"), this.myWorkingList.getPanel()); //$NON-NLS-1$
      jTabbed.addTab(Jibs.getString("Camera.5"), new CameraPanel(this)); //$NON-NLS-1$

      // Set up content pane
      JPanel thePanel = new JPanel(new BorderLayout());
      thePanel.add(jTabbed, BorderLayout.CENTER);
      this.setContentPane(new JScrollPane( thePanel ));
   } 


   void exit()
   {
      CameraPreferences.flush();
      if (this.iExitOnClose)
      {
         System.exit(0);
      }
      else
      {
         // TODO: May want to kill any running worker thread.
         // Would need to track in here and manage from the actual workers
         // adding an interupt reutine to the workers.
         this.setVisible(false);
         dispose();
      }
   }

   //===========================================================================
   //                              Main
   //===========================================================================
   public static void main(String[] args)
   {
      new Camera(true);
   }
}
