/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.dirtools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.prefs.Preferences;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.swing.JPanelRows;

import com.saic.isd.printscreen.Util;
import com.saic.isd.util.report.Report;

/**
 * User interface for the directory utilities.
 */
public class DirCopyPanel
   extends JPanelRows
{
   private static Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/dirtools/DirCopyPanel");
   static String TO_DIR = "TO_DIR";
   
   private static final String FILE_DATE_FORMAT = "yyyy.MM.dd-HH.mm.ss"; //$NON-NLS-1$
   private static final SimpleDateFormat FILE_DATE =
      new SimpleDateFormat(FILE_DATE_FORMAT);
  
	DirectoryCopy myDirTools;
   WorkerCopy myWorker;
   
   JLabel myCurrentAction = new JLabel("Idle");
   File myLogFile;

   private static final int DIR_COL_WIDTH = 50;
   JTextField toDirFld;
   JButton myStartBtn = new JButton(Jibs.getString("CameraPanel.3")); //$NON-NLS-1$

   //===========================================================================
   //                          Constructor
   //===========================================================================

   public DirCopyPanel(DirectoryCopy dirTools)
   {
      super();
      this.myDirTools = dirTools;

      // Layout To
      String toDir = FileUtil.checkDirectory(clsPrefs.get(
            TO_DIR,
            System.getProperty("user.home")));
      // In case directory erased somehow.
      if (toDir == null)
      {
      	toDir = System.getProperty("user.home");
      }
      this.toDirFld = new JTextField(toDir);
      this.toDirFld.setColumns(DIR_COL_WIDTH);

      JButton btnTo = new JButton("..."); //$NON-NLS-1$
      btnTo.addActionListener
         (
         new ActionListener()
      {
         public void actionPerformed(ActionEvent ae)
         {
            String dir = DirCopyPanel.this.toDirFld.getText();
            if (dir == null)
            {
               dir = System.getProperty("user.home"); //$NON-NLS-1$
            }
            dir = lookupDir("Copy To Directory", dir); //$NON-NLS-1$
            DirCopyPanel.this.toDirFld.setText(dir);
            setPrefsDirectory(TO_DIR,dir);
         }
      }
      );

     	final JButton btnStop = new JButton(Jibs.getString("CameraPanel.16")); //$NON-NLS-1$
      final JButton btnReport = new JButton(Jibs.getString("report")); //$NON-NLS-1$
      btnReport.setEnabled(false);

      this.myStartBtn.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
            doWork();
            btnReport.setEnabled(true);
            btnStop.setEnabled(true);
         }
      });

      btnStop.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
         	DirCopyPanel.this.myWorker.stop();
            btnStop.setEnabled(false);            
         }
      });
      
      btnReport.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
            try
            {
               String text = Util.getTextFromFile(DirCopyPanel.this.myLogFile);
               Report.showReport(
                  Jibs.getString("CameraPanel.30"), text, false); //$NON-NLS-1$
            }
            catch (Exception ex)
            {
               Report.showReport(
                  Jibs.getString("CameraPanel.20"), //$NON-NLS-1$
                  ex.getMessage(), false);
            }
         }
      });

      JPanel currentRow = super.topRow();
      currentRow.add(new JLabel("To Directory: "));
      currentRow.add(this.toDirFld);
      currentRow.add(btnTo);

      currentRow = super.nextRow();
      currentRow.add(this.myStartBtn);
      currentRow.add(btnStop);
      currentRow.add(btnReport);

      currentRow = super.nextRow();
      currentRow.add(new JLabel(" " + " " + Jibs.getString("CameraPanel.18") + Jibs.getString("colon") + " ")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
      currentRow.add(this.myCurrentAction);
   }

   String lookupDir(String msg, String prior)
   {
      JFileChooser chooser = new JFileChooser();
      chooser.setDialogTitle(msg);
      chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
      chooser.setCurrentDirectory(new File(prior));

      int returnVal = chooser.showOpenDialog(this);
      if (returnVal == JFileChooser.APPROVE_OPTION)
      {
         try
         {
            return chooser.getSelectedFile().getCanonicalPath();
         }
         catch (IOException ex)
         {
            ex.printStackTrace();
         }
      }
      return null;
   } // lookupDir()

   //===========================================================================
   //===========================================================================
   //                           WORK FUNCTIONS
   //===========================================================================
   //===========================================================================
   /**
    */
   void doWork()
   {
      String toDir = this.toDirFld.getText();
      
      String date = FILE_DATE.format(new Date());
      
      String logFileName =
      	this.toDirFld.getText()
         + System.getProperty("file.separator") + "jibsLog_" 
         + date + ".txt"; //$NON-NLS-1$
      this.myLogFile = new File(logFileName);

      try
      {
         this.myWorker = new WorkerCopy(this, toDir);
         Thread t = new Thread(this.myWorker);
         t.start();
      }
      catch (Exception ex)
      {
         JOptionPane.showMessageDialog(
            this,
            ex.getMessage(),
            Jibs.getString("CameraPanel.25"), //$NON-NLS-1$
            JOptionPane.ERROR_MESSAGE);
         ex.printStackTrace();
      }
   }
  
   static void setPrefsDirectory(String pref, String dir)

   {
      String validated = FileUtil.safeValidateDirectory(dir);
      if (validated != null)
      {
         clsPrefs.put(pref, validated);
      }
      else
      {
         clsPrefs.remove(pref);
      }
   }
}
