/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.help;

import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;

import com.saic.isd.util.report.Report;

/**
 * Display HTML information.
 */
public class HtmlViewer
   extends Report
{
   /*
    * =========================================================================
    *                         Constructor
    * =========================================================================
    */

   /**
    * Display HTML information.
    * @param title to show on the title bar of the window.
    */
   public HtmlViewer(String title)
   {
      super(title,"text/html"); //$NON-NLS-1$
   }

   public void displayHTML(String html)
   {
      this.myHTML = html;
      //myHTML = "<html><body>HI</body></html>";

      this.myEditorPane.setText(this.myHTML);
      this.setVisible(true);
      this.myEditorPane.setCaretPosition(0);
   }

   public boolean displayResource(String path)
   {
      try
      {
         InputStream in = this.getClass().getResourceAsStream(path);
         if (in == null)
         {
            System.out.println("Null input stream"); //$NON-NLS-1$
            return false;
         }
         StringWriter writer = new StringWriter(3000);
         int aChar = in.read();
         while (aChar > -1)
         {
            writer.write(aChar);
            aChar = in.read();
         }
         StringBuffer buff = writer.getBuffer();
         String html = remapImageTags(buff);
         displayHTML(html);
         return true;
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
         return false;
      }
   }

   private String remapImageTags(StringBuffer buff)
   {
      String imgPath = getPathToImages();

      // Fast exit if nothing to do...
      if (imgPath == null )
      {
         return buff.toString();
      }

      String tag = "src=\""; //$NON-NLS-1$
      int tagLength = tag.length();
      int index = buff.indexOf(tag,0);
      while( index > -1 )
      {
         int insertAt = index + tagLength;
         buff.insert(insertAt, imgPath);
         index = buff.indexOf(tag,insertAt);
      }
      return buff.toString();
   }

   /**
    * Only works for images in this directory.
    * Original idea came from:
    * http://www.javaworld.com/javatips/jw-javatip120_p.html
    * However, that article used getClass().getClassLoader().getSystemResource()
    * which always returns a null from a local jar file.  So does
    * getClass().getClassLoader().getResource().  Switching to
    * getClass().getResource() solved all problems.
    * @return path to images
    */
   private String getPathToImages()
   {
      String path = null;
      try
      {
         URL urlJar = this.getClass().getResource("tutorial.html"); //$NON-NLS-1$
         String urlStr = urlJar.toString();
         //System.out.println("URL: " + urlStr);
         int to = urlStr.indexOf("tutorial.html"); //$NON-NLS-1$
         path = urlStr.substring(0, to);
      }
      // Null pointer in particular if this is not run from jar file.
      catch( Exception ex )
      {
         ex.printStackTrace();
      }
      return path;
   }

   /**
    * Expriments leading to the development of getPathToImages()
    * @return jar file name
    */
   private String getJarFileName()
   {
      String className = this.getClass().getName() + ".class"; //$NON-NLS-1$
      //System.out.println("className: " + className);

      URL urlJar = null;
      urlJar = ClassLoader.getSystemResource(
               this.getClass().getName());
      System.out.println("urlJar a: " + urlJar); //$NON-NLS-1$
      urlJar = this.getClass().getClassLoader().getResource(
               this.getClass().getName());
      System.out.println("urlJar b: " + urlJar); //$NON-NLS-1$
      urlJar = ClassLoader.getSystemResource(className);
      System.out.println("urlJar c: " + urlJar); //$NON-NLS-1$
      urlJar = this.getClass().getClassLoader().getResource(className);
      System.out.println("urlJar d: " + urlJar); //$NON-NLS-1$
      urlJar = this.getClass().getClassLoader().getResource("banner.gif"); //$NON-NLS-1$
      System.out.println("urlJar e: " + urlJar); //$NON-NLS-1$
      urlJar = this.getClass().getClassLoader().getResource(
               "/org/gerhardb/jibs/help/banner.gif"); //$NON-NLS-1$
      System.out.println("urlJar f: " + urlJar); //$NON-NLS-1$
      urlJar = this.getClass().getResource("tutorial.html"); //$NON-NLS-1$
      System.out.println("urlJar e: " + urlJar); //$NON-NLS-1$
      urlJar = this.getClass().getResource(
               "/org/gerhardb/jibs/help/tutorial.html"); //$NON-NLS-1$
      System.out.println("urlJar f: " + urlJar); //$NON-NLS-1$
      return "ending early"; //$NON-NLS-1$
      /*
      if (true)
      {
         return "ending early"; //$NON-NLS-1$
      }
      String urlStr = urlJar.toString();
      //System.out.println("HTML Viewer URL: " + urlStr); //$NON-NLS-1$
      int from = "jar:file:".length(); //$NON-NLS-1$
      int to = urlStr.indexOf("!/"); //$NON-NLS-1$
      return urlStr.substring(from, to);
      */
   }

   public static void main(String[] args)
   {
      //HtmlViewer.printPrinterList();
      HtmlViewer htmlViewer = new HtmlViewer("JIBS Help"); //$NON-NLS-1$
      System.out.println(htmlViewer.getJarFileName());
      htmlViewer.displayResource("tutorial-viewer.html"); //$NON-NLS-1$
      // "/org/gerhardb/jibs/help/tutorial.html";
   }
}
