/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.producer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

import org.gerhardb.lib.image.ImageChangeUtil;

/**
 * JPanel implementation of showing a single image.
 */
public class PicturePanel extends JPanel
{
	static private final Color	OK_COLOR					= Color.black;	
	static private final Color	RESIZE_COLOR			= Color.black;	
	static private final Color	NFG_COLOR				= Color.green;

	// -------------------- Things passed into me -------------------------------
	private BufferedImage myCurrentImage;

	// ==========================================================================
	// Constructor
	// ==========================================================================
	public PicturePanel()
	{
		// We don't care
	}
   
	public void showPicture(BufferedImage image)
	{
		this.myCurrentImage = image;
		repaint();
	}

	protected void showNoPicture(Graphics g)
	{
		super.setBackground(NFG_COLOR);
		super.paintComponent(g); // Fill with background color.
		
		/*
		Graphics2D g2 = (Graphics2D)g;
		Font font = new Font("Default", Font.PLAIN, 24); //$NON-NLS-1$
		FontRenderContext fontRenderContext = g2.getFontRenderContext();

		TextLayout text = new TextLayout(Jibs.getString("Single.1"), font, fontRenderContext); //$NON-NLS-1$
		
		// Text is draw up from the Ascent and down from the Descent.
		int xCenter = getWidth() / 2;
		int yCenter = getHeight() / 2;
		
		
		int textX = xCenter - (int)text.getBounds().getWidth()/2;
		// This puts the text at the bottom of the box.
		int textY = (int) (yCenter - text.getDescent());
		//textY = (int) (textY + tlName.getAscent());
		text.draw(g2, textX, textY);
		*/
	}
	
   @Override
	public void paint(Graphics g)
   {
   	// Apparently, background color can only be set once per draw without
   	// confusing SWING.
   	Color backgroundColor = OK_COLOR; // DEFAULT COLOR
		
		BufferedImage showMe = this.myCurrentImage;
		if (showMe == null)
		{
			showNoPicture(g);
			return; 
		}

		//System.out.println("======================== showImage ============================");
		//System.out.println("Panel w h: " + super.getWidth() + " " + super.getHeight());
		//System.out.println("Raw Picture w h: " + showMe.getWidth() + " " + showMe.getHeight());		

   	// Resize
      BufferedImage originalImage = showMe;
      showMe = 
			ImageChangeUtil.fitAspectDown(
					showMe, 
					super.getWidth(), 
					super.getHeight());		
	
		// Check for resized color.
		if ( originalImage.getWidth() > showMe.getWidth() 
				|| originalImage.getHeight() > showMe.getHeight())
		{
			backgroundColor = RESIZE_COLOR;
		}
		
		//System.out.println("Sized Picture w h: " + showMe.getWidth() + " " + showMe.getHeight());		
      

      // Now the the correct background color has been established,
      // use it.
		super.setBackground(backgroundColor); 
		super.paintComponent(g);  // First, fill with background color.
		
		Graphics2D g2 = (Graphics2D)g;
      
		// Figure out centering
		int centerWidth = ((super.getWidth() - showMe.getWidth()) / 2);
		if (centerWidth < 0)
		{
			centerWidth = 0;
		}
		
		int centerHeight = ((super.getHeight() - showMe.getHeight()) / 2);
		if (centerHeight < 0)
		{
			centerHeight = 0;
		}
		
		// Draw the new image
      g2.drawImage(showMe, null, centerWidth, centerHeight);
   }
}

