/*
 * Copyright (c) 2008 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.producer;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * &amp; 	&
 * &apos; 	'
 * &quot; 	"
 * &lt; 	   <
 * &gt; 	   >
 * @author Gerhard
 *
 */
public class Play
{
	File myFile;
	int myMinSeconds;
	String myCaption;
	List<Audio> myAudioFiles = new ArrayList<Audio>();
	
	public Play()
	{
		// We don't care
	}

	public void addAudio(Audio audio)
	{
		this.myAudioFiles.add(audio);
	}
	
	public Audio[] getAudio()
	{
		Audio[] rtnMe = new Audio[this.myAudioFiles.size()];
		this.myAudioFiles.toArray(rtnMe);
		return rtnMe;
	}
	
	public File getImageFile()
	{
		return this.myFile;
	}

	public void setImageFile(String fileName)
	{
		if (fileName != null && fileName.length() > 0)
		{
			setImageFile(new File(fileName));
		}
	}

	public void setImageFile(File file)
	{
		this.myFile = file;
	}

	public int getMinSeconds()
	{
		return this.myMinSeconds;
	}

	public void setMinSeconds(String minSeconds)
	{
		try
		{
			setMinSeconds(Integer.parseInt(minSeconds));
		}
		catch(NumberFormatException ex)
		{
			System.out.println("minSeconds must be an integer, not: " + minSeconds);
		}
	}

	public void setMinSeconds(int minSeconds)
	{
		this.myMinSeconds = minSeconds;
	}

	public String getCaption()
	{
		return this.myCaption;
	}

	public void setCaption(String caption)
	{
		this.myCaption = caption;
	}
	
	@Override
	public String toString()
	{
		StringBuffer buff = new StringBuffer(500);
		buff.append("Caption: " + this.myCaption + "\n"); 
		buff.append("File: " + this.myFile + "\n"); 
		buff.append("Minimum Seconds: " + this.myMinSeconds + "\n"); 
		Iterator<Audio> it = this.myAudioFiles.iterator();
		while (it.hasNext())
		{
			buff.append(it.next().toString());
		}
		return buff.toString();
	}
	
}
