/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.producer;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Date;

import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.sound.SoundPlayer;

/**
 Runs the whole play list.
 */
public class PlayListPlayer
{
	Play[] myPlayList = new Play[0];
	int myCurrentItem = -1;
	ImageFactory myImageFactory;
   SoundPlayer mySoundPlayer = new SoundPlayer();
   //ThreadedSoundPlayer mySoundPlayer = new ThreadedSoundPlayer();
   IPictureShow myPictureShower;
   boolean iPlay = false;
	
	public PlayListPlayer(IPictureShow show)
	{		
		this.myPictureShower = show;
		this.myImageFactory = ImageFactory.getImageFactory();
	}
	
	public void setPlayList(Play[] playList)
	{
		this.myCurrentItem = -1;
		if (playList == null)
		{
			this.myPlayList = new Play[0];
		}
		else
		{
			this.myPlayList= playList;
		}
	}
	
	public void next()
	{
		this.myCurrentItem++;
		if (this.myCurrentItem >= this.myPlayList.length)
		{
		   this.iPlay = false;		
		   return;			
		}
		Date startedAt = new Date();
		this.myPictureShower.showPicture(getCurrentImage());
		this.myPictureShower.showCaption(this.myPlayList[this.myCurrentItem].getCaption());
		Audio[] audio = this.myPlayList[this.myCurrentItem].getAudio();
		for(int i=0; i<audio.length; i++)
		{
			File file = audio[i].getFile();
			//System.out.println("File name retrieved: " + file);
		   this.mySoundPlayer.play(file);
		}
		if (this.myPlayList[this.myCurrentItem].getMinSeconds() > 0)
		{
			int minRunTime = 1000 * this.myPlayList[this.myCurrentItem].getMinSeconds();
			Date finishedAt = new Date();
			long milliSecondsRan = finishedAt.getTime() - startedAt.getTime();
			if (minRunTime > milliSecondsRan)
			{
	        try
	         {
	            Thread.sleep(minRunTime - milliSecondsRan);
	         }
	         catch (Exception ex)
	         {
	            ex.printStackTrace();
	         }				
			}
		}
	}
	
	public void auto()
	{
	   this.iPlay = true;		
      Thread t = new Thread(new AutoPlay());
      t.start();
	}
	
	public void stop()
	{
	   this.iPlay = false;		
	}
	
   //===========================================================================
   //                              Private
   //===========================================================================
	class AutoPlay implements Runnable
	{
		public void run()
		{
		   while(PlayListPlayer.this.iPlay)
		   {
		   	next();
		   }	
		}
	}
	
	private BufferedImage getCurrentImage()
	{
		if (this.myCurrentItem < 0 || this.myCurrentItem >= this.myPlayList.length)
		{
			return null;
		}
		File imageFile = this.myPlayList[this.myCurrentItem].getImageFile();
		//System.out.println("ImageFile: " + imageFile);
		return this.myImageFactory.getImageEZ(imageFile);
	}
} 
