/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.textCompare;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;

import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import org.gerhardb.lib.util.*;
import org.gerhardb.lib.io.*;
import java.awt.*;
import javax.swing.JButton;


/**
 * User interface for the Camera.
 */
public class TextComparePanel
   extends JPanel implements DirListController.Clearable
{
   TextCompareGUI myGUI;
   Stoppable myWorker;
   
   JProgressBar myProgressBar = new JProgressBar();
   JLabel myCurrentAction = new JLabel("Ready to start scan...");

   JButton myStartBtn = new JButton("Scan"); 
	JButton myStopBtn = new JButton("Stop"); 
	
	DefaultListModel myPossibleDuplicates = new DefaultListModel();
	JList myList = new JList(this.myPossibleDuplicates);
	TextFilePanel myLeftText = new TextFilePanel(this);
	TextFilePanel myRightText = new TextFilePanel(this);
   JPanel myComparePanel = new JPanel(new BorderLayout());
	
	private int myCurrentIndex = -1;

   //===========================================================================
   //                          Constructor
   //===========================================================================

   public TextComparePanel(TextCompareGUI gui)
   {
      super();
      this.myGUI = gui;
      
      clear();

      this.myList.addListSelectionListener(new TCListListener());
      this.myList.setPrototypeCellValue(new TextCompareListItem("foo", "bar"));
      
      this.myComparePanel.add(new JScrollPane(this.myLeftText), BorderLayout.WEST);
      this.myComparePanel.add(new JScrollPane(this.myRightText), BorderLayout.EAST);
      this.myStartBtn.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
         	clear();
            doWork();
         }
      });
      this.myStopBtn.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
         	TextComparePanel.this.myWorker.stop();
         	TextComparePanel.this.myStopBtn.setEnabled(false);            
         }
      });
      
      layoutGridBag();
      
   }
   
	void layoutGridBag()
	{
		this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);

		this.setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();		
		
		// natural height, maximum width
		c.gridx = 0; //Default: GridBagConstraints.RELATIVE which is -1
		c.gridy = 0; //Default: GridBagConstraints.RELATIVE which is -1
		c.gridwidth = 1;
		c.gridheight = 1;
		c.weightx = 0.5; // Allow to expand right and left.  Default is 0.
		c.weighty = 0;
		c.anchor = GridBagConstraints.NORTHWEST; 
		c.fill = GridBagConstraints.NONE;
		c.insets = new Insets(0, 0, 0, 0);
		c.ipadx = 0;
		c.ipady = 0;
		
		// ===============================================
		// Row Row Row Row Row Row Row Row Row Row Row Row
		// ===============================================
		c.gridy = 0;
		c.gridwidth = 1;
		c.fill = GridBagConstraints.HORIZONTAL;
		
		c.gridx = 0;
		this.add(this.myStartBtn, c);
		
		c.gridx = 1;
		this.add(this.myStopBtn, c);
		
		// ===============================================
		// Row Row Row Row Row Row Row Row Row Row Row Row
		// ===============================================
		c.gridy++;
		c.gridx = 0;
		c.gridwidth = 2;
		
	   JPanel aPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
	   aPanel.add(new JLabel("Progress:  ")); 
	   aPanel.add(this.myCurrentAction);
		this.add(aPanel, c);

		// ===============================================
		// Row Row Row Row Row Row Row Row Row Row Row Row
		// ===============================================
		c.gridy++;
		
		this.add(this.myProgressBar, c);
		
		// ===============================================
		// Row Row Row Row Row Row Row Row Row Row Row Row
		// ===============================================
		c.gridy++;
		
		this.add(new JLabel("  Duplicates:"), c);
		
		// ===============================================
		// Row Row Row Row Row Row Row Row Row Row Row Row
		// ===============================================
		c.gridy++;
		//c.gridheight = 4;
		
		JScrollPane listSP = new JScrollPane(this.myList);
		listSP.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
		listSP.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		listSP.setPreferredSize(new Dimension(600,120));
		// width, height

		this.add(listSP, c);
		
		// ===============================================
		// Row Row Row Row Row Row Row Row Row Row Row Row
		// ===============================================
		c.gridy++;
		c.gridwidth = 1;
		c.weighty = 1.0; //request any extra vertical space
		c.fill = GridBagConstraints.BOTH;

		// First Column
		c.gridx = 0;
		this.add(this.myLeftText.getTextArea(), c);

		// Second Column
		c.gridx = 1;
		this.add(this.myRightText.getTextArea(), c);
		
		// ===============================================
		// Row Row Row Row Row Row Row Row Row Row Row Row
		// ===============================================
		c.gridy++;
		c.weighty = 0.0; 
		c.fill = GridBagConstraints.HORIZONTAL;
		
		// First Column
		c.gridx = 0;
		this.add(this.myLeftText.getFilePanel(), c);
		
		// Second Column
		c.gridx = 1;
		this.add(this.myRightText.getFilePanel(), c);
		
		// ===============================================
		// Row Row Row Row Row Row Row Row Row Row Row Row
		// ===============================================
		c.gridy++;

		// First Column
		c.gridx = 0;
		this.add(this.myLeftText.getDeleteButton(), c);
		
		// Second Column
		c.gridx = 1;
		this.add(this.myRightText.getDeleteButton(), c);		
	}
   
   //===========================================================================
   //===========================================================================
   //                           WORK FUNCTIONS
   //===========================================================================
   //===========================================================================
	void delete(File file)
	{
   	if (file == null || !file.exists())
   	{
   		return;
   	}
		try
		{
			if (!file.delete())
			{
            JOptionPane.showMessageDialog(
            	this,
               "Could not delete: " + file,
               "File Delete",
               JOptionPane.ERROR_MESSAGE);   		
            return;
			}
			System.out.println("Deleted: " + file);
			this.myCurrentIndex = -1;
			this.myList.setSelectedIndex(-1);
			this.myLeftText.clear();
			this.myRightText.clear();
			int index = this.myPossibleDuplicates.getSize() - 1;
			for(; index>-1; index--)
			{			
				TextCompareListItem item = (TextCompareListItem)this.myPossibleDuplicates.get(index);
				System.out.println("Comparing: " + item);
				if (item.getLeftFile().equals(file) || item.getRightFile().equals(file))
				{
					if (this.myPossibleDuplicates.remove(index) != null)
					{
						System.out.println("Removed!");						
					}
					else
					{
						System.out.println("Missing!");						
					}
				}   						
			}
			/*
			Enumeration items = myPossibleDuplicates.elements();
			while(items.hasMoreElements())
			{
				TextCompareListItem item = (TextCompareListItem)items.nextElement();
				System.out.println("Comparing: " + item);
				if (item.getLeftFile().equals(file) || item.getRightFile().equals(file))
				{
					if (myPossibleDuplicates.removeElement(item))
					{
						System.out.println("Removed!");						
					}
					else
					{
						System.out.println("Missing!");						
					}
				}   				
			}
			*/
			this.myList.repaint();
			// Set selection to first file.
			this.myList.setSelectedIndex(0);
			updateSelectedItem();
			
			this.repaint();
		}
		catch(Exception ex)
		{
         ex.printStackTrace();
         JOptionPane.showMessageDialog(
         	this,
            ex.getMessage(),
            "File Delete",
            JOptionPane.ERROR_MESSAGE);
		}	
	}
	
	public void clear()
	{
		System.out.println("Clearing fields");
		this.myStartBtn.setEnabled(true); 
		this.myStopBtn.setEnabled(false); 
		this.myCurrentIndex = -1;
		this.myList.setSelectedIndex(-1);
   	this.myProgressBar.getModel().setMaximum(50);
   	this.myProgressBar.getModel().setValue(0);
      this.myLeftText.clear();
      this.myRightText.clear();
      this.myPossibleDuplicates.clear();
	}
	
   class TCListListener implements ListSelectionListener
   {
		public void valueChanged(ListSelectionEvent e)
		{
			updateSelectedItem();
		}
   }
   
   void updateSelectedItem()
   {
		int index = this.myList.getSelectedIndex();
		//System.out.println("Picked: " + index);
		if (this.myCurrentIndex != index && index > -1)
		{
			this.myCurrentIndex = index;
			TextCompareListItem item = (TextCompareListItem)this.myPossibleDuplicates.get(this.myCurrentIndex);
			if (item != null)
			{
				//System.out.println("Item: " + item);
				try
				{
					this.myLeftText.setFile(item.getLeftFile());
					this.myRightText.setFile(item.getRightFile());
				}
				catch(Exception ex)
				{
					ex.printStackTrace();
				}
			}
		}   	
   }

   
   /**
    */
   void doWork()
   {
         this.myWorker = new TextCompareWorker(
                               this.myGUI.myWorkingList.getDirArray(),
                               this.myPossibleDuplicates,
                               this
                               );
                               
         // Evaluate this thread for EventQueue.invokeLater(new Runnable()
         Thread t = new Thread(this.myWorker);
         t.start();
   }
}
