package org.gerhardb.jibs.textCompare;


import java.io.*;

import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.util.*;
import java.util.*;

import javax.swing.DefaultListModel;

/**
 * PRESUMED BEST VERSION
 * Orginal done with JBuilder!
 */
public class TextCompareWorker implements Stoppable
{
	DefaultListModel myPossibleDuplicates;	
	TextComparePanel myPanel;
	File[] myDirectories;
   File[] myFiles;
   String[] myBigSamples;
   boolean iStop = false;
   
   int maxTextToLookAt = 50000;   // 15000
   int cutoverFromAllToCompareTo = 1000;  //500
   int compareToStart = 500;      // 200
   int compareToStop = this.cutoverFromAllToCompareTo; 		 // 300
   int cutoverSampleA = 200;   // 200
   int samplePitchA = 100; // 100
   int cutoverSampleB = 400;  // 400
   int samplePitchB = 200; // 200
   int sampleSize = 20; // 20

   public TextCompareWorker(File[] directories, DefaultListModel dups, TextComparePanel panel)
   {
   	this.myDirectories = directories;
   	this.myPossibleDuplicates = dups;
   	this.myPanel = panel;
   }
   
   //===========================================================================
   //                          Stoppable
   //===========================================================================
   public void run()
   {
      this.myPanel.myStartBtn.setEnabled(false);
      this.myPanel.myStopBtn.setEnabled(true);
   	this.myPanel.myCurrentAction.setText("Getting Files");
      Arrays.sort(this.myDirectories);

      ArrayList<File> theList = new ArrayList<File>(5000);
      for (int i = 0; i < this.myDirectories.length; i++)
      {
         //System.out.println("Adding FILES for: " + myDirectories[i]);
         File[] someFiles = this.myDirectories[i].listFiles();
         for (int j = 0; j < someFiles.length; j++)
         {
            if (someFiles[j].isFile())
            {
               theList.add(someFiles[j]);
            }
         }
      }
      this.myFiles = new File[theList.size()];
      theList.toArray(this.myFiles);
      theList = null;
      Arrays.sort(this.myFiles);
      //System.out.println("FILE COUNT: " + myFiles.length);

   	this.myPanel.myCurrentAction.setText("Getting Samples");
      this.myBigSamples = new String[this.myFiles.length];
      for (int i = 0; i < this.myBigSamples.length; i++)
      {
         try{addSample(i);}
         catch(Exception ex)
         {
         	ex.printStackTrace();
         }
         if (this.iStop)
         {
           	this.myPanel.myCurrentAction.setText("Stopped");
           	return;      	
         }
      }

      //System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
      try
      {
        	this.myPanel.myCurrentAction.setText("Comparing Files");
      	compareList();
      }
      catch(Exception ex)
      {
      	ex.printStackTrace();
      }
      this.myPanel.myStartBtn.setEnabled(true);
      this.myPanel.myStopBtn.setEnabled(false);
      System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
      System.out.println("                    ALL DONE!");
      System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");   	
   }
   
   public void stop()
   {
   	this.iStop = true;
   }
   //===========================================================================
   //                          Other
   //===========================================================================

   void addSample(int index)
      throws Exception
   {
      File aFile = this.myFiles[index];
   	//System.out.println("Adding Sample: " + aFile);
      String text = FileUtil.getStringFromFile(aFile);
      if ( text.length() > this.maxTextToLookAt )
      {
         text = text.substring(this.maxTextToLookAt);
      }
     	//System.out.println("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
   	//System.out.println("text: " + text);
      String[] words = text.split("\\W+");  // split on word boundaries (non word characters actually)//" \t\n\r\f");
      text = null;
      
      //System.out.println( "Tokens: " + words.length );
      
      int start = 0;
      int stop = words.length;
      
      if (words.length > this.cutoverFromAllToCompareTo)
      {
      	start = this.compareToStart;
         stop = this.compareToStop;
      }
      
      StringBuffer buff = new StringBuffer(2000);
      for (int i = start; i < stop; i++)
      {
         buff.append(words[i]);
         buff.append(" ");
      }
      this.myBigSamples[index] = buff.toString();
      
   	//System.out.println("----------------------------- Sample: " +  myBigSamples[index]);
   }

   void compareList()
      throws Exception
   {
   	this.myPanel.myProgressBar.getModel().setMaximum(this.myFiles.length);
      for (int i = 0; i < this.myFiles.length; i++)
      {
         //System.out.println("=========================================================" );
         //System.out.println("File #" + i);
         //System.out.println( "Base File: " + myFiles[i] );
         //System.out.println( "Sample In Index: " + myBigSamples[i] );
         if ( this.myBigSamples[i] != null )
         {
            String[] words = this.myBigSamples[i].split("\\W+");  // split on word boundaries
            StringBuffer testBuff = new StringBuffer(10000);
/*
            for (int j = 0; j < words.length; j++)
            {
               System.out.println(words[j]);
            }
*/
            
            int maxThrowAway = 0;
            if (words.length > this.cutoverSampleA)
            {
            	maxThrowAway = this.samplePitchA;
            }
            else if (words.length > this.cutoverSampleB)
            {
            	maxThrowAway = this.samplePitchB;
            }
            
            int upperLimit = maxThrowAway + this.sampleSize;
            if (upperLimit > words.length)
            {
            	upperLimit = words.length;
            }

            //System.out.println("words.length: " + words.length);
            //System.out.println("maxThrowAway: " + maxThrowAway);
            //System.out.println("upperLimit: " + upperLimit);
            for (int j = maxThrowAway; j < upperLimit; j++)
            {
               //System.out.println(">>>>: " + words[j]);
            	testBuff.append(words[j]);
            	testBuff.append(" ");
            }
            String compareSample = testBuff.toString();
            //System.out.println("ffo: " + compareSample);
            findComparables(i, compareSample);
         }
         this.myPanel.myProgressBar.getModel().setValue(i + 1);
         if (this.iStop)
         {
           	this.myPanel.myCurrentAction.setText("Stopped");
           	return;      	
         }
      }
     	this.myPanel.myCurrentAction.setText("Done");
   }

   void findComparables(int baseIndex, String compare)
      throws Exception
   {
      //System.out.println( "Base String: " + compare + "\n");
      for (int i = baseIndex + 1; i < this.myFiles.length; i++)
      {
         //System.out.println( "Target File: " + myFiles[i] );
         String testSample = this.myBigSamples[i];
         //System.out.println( "Target String: " + testSample + "\n");
         if ( testSample != null )
         {
            if (testSample.indexOf(compare) > -1)
            {
            	/*
               String msg =
                  "POSSIBLE MATCH: "
                  + "\n     " + myFiles[baseIndex]
                  + "\n     " + myFiles[i];
               System.out.println(msg);
               */
            	File[] deleteDir = new File[]{};
               TextCompareListItem item = new TextCompareListItem(this.myFiles[baseIndex], this.myFiles[i]);
               if (!item.autoRemoved(deleteDir))
               {
               	this.myPossibleDuplicates.addElement(item);
               }
            }
         }
         if (this.iStop)
         {
           	this.myPanel.myCurrentAction.setText("Stopped");
           	return;      	
         }
      }
   }

}