/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.jibs.textPad;

import java.awt.Cursor;
import java.awt.event.*;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.LicenseBox;
import org.gerhardb.lib.print.PrintableText;
import org.gerhardb.lib.scroller.ScrollerUtils;
import org.gerhardb.lib.util.ActionHelpers;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.app.AboutBox;
import org.gerhardb.lib.util.app.AppUtils;
import org.gerhardb.lib.util.app.Info;
import org.gerhardb.lib.util.startup.*;

/**
 * Trying to remove clutter from main SortScreen and support
 * internationalized accelerated iconized menus.
 */
public class TextPadActions extends ActiveActions
{
	TextPad myTextPad;
	
	public TextPadActions(TextPad ss)
	{
		this.myTextPad = ss;
		super.initialize();
	}
	

	@Override
	public Action getAction(String menu, String item)
	{
		// Menus orginally set up this way...
		menu = "SortScreen.menu" + "." + menu; //$NON-NLS-1$
		return super.getAction(menu, item);
	}
	
	/**
	 * Points to class in here with factory default options.
	 * Viewer can change these, then revert to factory defaults.
	 * @see org.gerhardb.lib.util.startup.ActiveActions#getStartupActions()
	 */
	@Override
	protected FactoryDefaultActions getFactoryDefaultActions()
	{
		return new DefaultStartupActions();
	}
	
	// ==========================================================================
	// Starter Actions and Defaults
	// ==========================================================================
	
	/**
	 * Factory Default options.
	 */
	private class DefaultStartupActions extends FactoryDefaultActions
	{
		public DefaultStartupActions()
		{
			// These just click on the toolbar but have the menu accelerators
			addStartupAction("SortScreen.menu","file", "repeat", new RepeatAction(), Icons.getIcon(Icons.REPEAT)); //$NON-NLS-1$ //$NON-NLS-2$
			addStartupAction("SortScreen.menu","file", "park", new ParkAction(), Icons.getIcon(Icons.PARK)); //$NON-NLS-1$ //$NON-NLS-2$
			addStartupAction("SortScreen.menu","file", "trash", new DeleteAction(), Icons.getIcon(Icons.DELETE)); //$NON-NLS-1$ //$NON-NLS-2$
			addStartupAction("SortScreen.menu","file", "directoryList", new DirectoryListAction(), Icons.getIcon(Icons.DIRECTORY_LIST)); //$NON-NLS-1$ //$NON-NLS-2$
			
			addStartupAction("SortScreen.menu","file", "openview", new ViewDirectoryAction(), null); //$NON-NLS-1$ //$NON-NLS-2$
			addStartupAction("SortScreen.menu","file", "opentree", new TreeDirectoryAction(), null); //$NON-NLS-1$ //$NON-NLS-2$
	      try
	      {
	      	if (AppStarter.isJava6Enabled())
	      	{
		      	Action defaultFileViewerAction = ScrollerUtils.getDefaultFileViewerAction(TextPadActions.this.myTextPad.myLST.getScroller());
		      	if (defaultFileViewerAction != null)
		      	{
		      		addStartupAction("SortScreen.menu","file", "defaultFileView", defaultFileViewerAction, null); //$NON-NLS-1$ //$NON-NLS-2$
		      	}
	      	}
	      }
	      catch(NoClassDefFoundError ex)
	      {
	      	ex.printStackTrace();
	      }			
			addStartupAction("SortScreen.menu","file", "empty", new EmptyTrashAction(), null); //$NON-NLS-1$ //$NON-NLS-2$	
				
			addStartupAction("SortScreen.menu","file", "rename", new RenameAction(), Icons.getIcon(Icons.RENAME)); //$NON-NLS-1$ //$NON-NLS-2$
			addStartupAction("SortScreen.menu","file", "exit", new ExitAction(), null); //$NON-NLS-1$ //$NON-NLS-2$

			addStartupAction("SortScreen.menu","edit", "undo", new UndoAction(), Icons.getIcon(Icons.UNDO)); //$NON-NLS-1$ //$NON-NLS-2$
			addStartupAction("SortScreen.menu","edit", "redo", new RedoAction(), Icons.getIcon(Icons.REDO)); //$NON-NLS-1$ //$NON-NLS-2$
			addStartupAction("SortScreen.menu","edit", "copy", new CopyAction(), null); //$NON-NLS-1$ //$NON-NLS-2$
			addStartupAction("SortScreen.menu","edit", "all", new SelectAllAction(), null); //$NON-NLS-1$ //$NON-NLS-2$

			addStartupAction("SortScreen.menu","view", "reload", new ReloadAction(), Icons.getIcon(Icons.REFRESH)); //$NON-NLS-1$ //$NON-NLS-2$
			addStartupAction("SortScreen.menu","view", "back", new BackAction(), Icons.getIcon(Icons.BACK)); //$NON-NLS-1$ //$NON-NLS-2$
			addStartupAction("SortScreen.menu","view", "forward", new ForwardAction(), Icons.getIcon(Icons.FORWARD)); //$NON-NLS-1$ //$NON-NLS-2$
			
			addStartupAction("SortScreen.menu","help", "help", new HelpAction(), Icons.getIcon(Icons.HELP)); //$NON-NLS-1$ //$NON-NLS-2$
			addStartupAction("SortScreen.menu","help", "about", new AboutAction(), Icons.getIcon(Icons.ABOUT)); //$NON-NLS-1$ //$NON-NLS-2$
			addStartupAction("SortScreen.menu","help", "license", new LicenseAction(), null); //$NON-NLS-1$ //$NON-NLS-2$
			addStartupAction("SortScreen.menu","help", "info", new InfoAction(), null); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}
	
	class DeleteAction extends AbstractAction
	{
		DeleteAction()
		{
			super(null, Icons.getIcon(Icons.DELETE));
		}

		public void actionPerformed(ActionEvent ae)
		{
			TextPadActions.this.myTextPad.myLST.getRDPmanager().clickTrash();
		}
	}

	class ParkAction extends AbstractAction
	{
		ParkAction()
		{
			super(null, Icons.getIcon(Icons.PARK));
		}

		public void actionPerformed(ActionEvent ae)
		{
			TextPadActions.this.myTextPad.myLST.getRDPmanager().clickPark();
		}
	}

	class RepeatAction extends AbstractAction
	{
		RepeatAction()
		{
			super(null, Icons.getIcon(Icons.REPEAT));
		}

		public void actionPerformed(ActionEvent ae)
		{
			TextPadActions.this.myTextPad.myLST.getRDPmanager().clickRepeat();			
		}
	}

	class DirectoryListAction extends AbstractAction
	{
		DirectoryListAction()
		{
			super(null, Icons.getIcon(Icons.DIRECTORY_LIST));
		}

		public void actionPerformed(ActionEvent ae)
		{
			TextPadActions.this.myTextPad.myLST.getRDPmanager().clickDirectoryList();			
		}
	}

	// ==========================================================================
	// Helper Methods
	// ==========================================================================
		
	@Override
	public JButton getToolBarButton(String menu, String item)
	{
		JButton rtnMe = getAccelleratedToolBarButton(menu, item);
		return rtnMe;
	}
	
	
	// ==========================================================================
	// FILE Menu
	// ==========================================================================
	JMenu getFileMenu()
	{
		JMenuItem openOneFileMenu = new JMenuItem("Open File"); // myEditorPane //$NON-NLS-1$
		openOneFileMenu.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				TextPadActions.this.myTextPad.open();
			}
		});

		/*
		JMenuItem printPreviewMenu = new JMenuItem(Jibs
				.getString("print.preview") + "..."); //$NON-NLS-1$ //$NON-NLS-2$
		printPreviewMenu.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				PrintableText pt = new PrintableText(myTextPad.myEditorPane);
				pt.previewHTML(myTextPad);
			}
		});

		JMenuItem printImageMenu = new JMenuItem("Print...", KeyEvent.VK_P); //$NON-NLS-1$
		printImageMenu.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				new PrintableText(myTextPad.myEditorPane).printContent();
			}
		});

		JMenuItem printTextMenu = new JMenuItem("Print Text...", KeyEvent.VK_T); //$NON-NLS-1$
		printTextMenu.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				myTextPad.printWithService();
			}
		});
*/
		JMenuItem copyMenu = new JMenuItem("Copy All"); //$NON-NLS-1$
		copyMenu.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				new PrintableText(TextPadActions.this.myTextPad.myEditorPane).copy();
			}
		});
		
		JMenu move = ActionHelpers.makeMenu("move"); //$NON-NLS-1$
		move.add(makeMenuItem("file", "repeat")); //$NON-NLS-1$ //$NON-NLS-2$
		move.add(makeMenuItem("file", "park")); //$NON-NLS-1$ //$NON-NLS-2$
		move.add(makeMenuItem("file", "trash")); //$NON-NLS-1$ //$NON-NLS-2$
		move.add(makeMenuItem("file", "directoryList")); //$NON-NLS-1$ //$NON-NLS-2$
		
		JMenu fileMenu = ActionHelpers.makeMenu("file"); //$NON-NLS-1$
		fileMenu.add(openOneFileMenu);
		fileMenu.add(makeMenuItem("file", "openview")); //$NON-NLS-1$ //$NON-NLS-2$
		fileMenu.add(this.myTextPad.myLST.getPathManager().getRecentDirMenu()); 	
		fileMenu.add(makeMenuItem("file", "opentree")); //$NON-NLS-1$ //$NON-NLS-2$
		fileMenu.add(this.myTextPad.myLST.getPathManager().getRecentTreeMenu()); 	

		// Special because it may not be here for Java 4
		Action action = getAction("file", "defaultFileView");
		if (action != null)
		{
			fileMenu.add(new JMenuItem(action));
		}
		
		fileMenu.addSeparator();
		fileMenu.add(move);
		fileMenu.add(makeMenuItem("file", "empty")); //$NON-NLS-1$ //$NON-NLS-2$
		fileMenu.addSeparator();
		//menu.add(makeMenuItem("file", "save")); //$NON-NLS-1$ //$NON-NLS-2$
		//menu.add(makeMenuItem("file", "saveas")); //$NON-NLS-1$ //$NON-NLS-2$
		//menu.add(makeMenuItem("file", "rename")); //$NON-NLS-1$ //$NON-NLS-2$
		//fileMenu.addSeparator();
		//fileMenu.add(printPreviewMenu);
		//fileMenu.add(printImageMenu);
		//fileMenu.addSeparator();
		
		JMenuItem exit = makeMenuItem("file", "exit"); //$NON-NLS-1$ //$NON-NLS-2$
		String closeOrExit = "Close";
		if (this.myTextPad.iExitOnClose)
		{
			closeOrExit = "Exit";
		}
		exit.setText(closeOrExit);
		fileMenu.add(exit);
		return fileMenu;
	}

	
	class EmptyTrashAction extends AbstractAction
	{
		public void actionPerformed(ActionEvent e)
		{
			TextPadActions.this.myTextPad.myLST.getRDPmanager().emptyTrash();
		}
	}

	class ExitAction extends AbstractAction
	{
		public void actionPerformed(ActionEvent e)
		{
			TextPadActions.this.myTextPad.exit();
		}
	}	
	
	class ViewDirectoryAction extends AbstractAction
	{
		public void actionPerformed(ActionEvent e)
		{
			TextPadActions.this.myTextPad.myLST.getFileListManager().askUserForViewDirectory(TextPadActions.this.myTextPad);
		}
	}

	class TreeDirectoryAction extends AbstractAction
	{
		public void actionPerformed(ActionEvent e)
		{
			TextPadActions.this.myTextPad.myLST.getTreeManager().setTreeDirectory();
		}
	}
	
	// ==========================================================================
	// EDIT Menu
	// ==========================================================================

	JMenu getEditMenu()
	{
		JMenu menu = ActionHelpers.makeMenu("edit"); //$NON-NLS-1$
		menu.add(makeMenuItem("edit", "undo")); //$NON-NLS-1$ //$NON-NLS-2$
		menu.add(makeMenuItem("edit", "redo")); //$NON-NLS-1$ //$NON-NLS-2$
		//menu.addSeparator();
		//menu.add(makeMenuItem("edit", "copy")); //$NON-NLS-1$ //$NON-NLS-2$
		//menu.add(makeMenuItem("edit", "all")); //$NON-NLS-1$ //$NON-NLS-2$
		return menu;
	}

	class UndoAction extends AbstractAction
	{
		public void actionPerformed(ActionEvent ae)
		{
			TextPadActions.this.myTextPad.myLST.getRDPmanager().getMoveManager().getUndoManager().undo();
			TextPadActions.this.myTextPad.myLST.getRDPmanager().getMoveManager().updateUndoRedoButtons();
		}
	}

	class RedoAction extends AbstractAction
	{
		public void actionPerformed(ActionEvent ae)
		{
			TextPadActions.this.myTextPad.myLST.getRDPmanager().getMoveManager().getUndoManager().redo();
			TextPadActions.this.myTextPad.myLST.getRDPmanager().getMoveManager().updateUndoRedoButtons();
		}
	}
	
	class CopyAction extends AbstractAction
	{

		public void actionPerformed(ActionEvent e)
		{
			System.out.println("myTextPad.myShow.getSaver().copy(); not yet available.");
			//myTextPad.myShow.getSaver().copy();  // This is not what we need I don't think...
		}
	}	
	
	class SelectAllAction extends AbstractAction
	{
		public void actionPerformed(ActionEvent e) 
		{
			JList list = TextPadActions.this.myTextPad.myLST.getFileList();
			list.clearSelection();
			list.addSelectionInterval(0, list.getModel().getSize() - 1);
			TextPadActions.this.myTextPad.myLST.showPageFromScroller();
		}
	}

	// ==========================================================================
	// VIEW Menu
	// ==========================================================================
	JMenu getViewMenu()
	{
		JMenu menu = ActionHelpers.makeMenu("view"); //$NON-NLS-1$
		menu.add(makeMenuItem("view", "reload")); //$NON-NLS-1$ //$NON-NLS-2$
		menu.add(makeMenuItem("view", "back")); //$NON-NLS-1$ //$NON-NLS-2$
		menu.add(makeMenuItem("view", "forward")); //$NON-NLS-1$ //$NON-NLS-2$
		//menu.addSeparator();
		return menu;
	}

	class ReloadAction extends AbstractAction
	{
		public void actionPerformed(ActionEvent ae)
		{
			TextPadActions.this.myTextPad.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
			TextPadActions.this.myTextPad.myLST.reloadScroller();  
			TextPadActions.this.myTextPad.setCursor(Cursor.getDefaultCursor());
		}
	}

	class BackAction extends AbstractAction
	{
		public void actionPerformed(ActionEvent ae)
		{
			TextPadActions.this.myTextPad.myLST.getFileListManager().back();  
		}
	}

	class ForwardAction extends AbstractAction
	{
		public void actionPerformed(ActionEvent ae)
		{
			TextPadActions.this.myTextPad.myLST.getFileListManager().forward(); 
		}
	}

	// ==========================================================================
	// TOOLS Menu
	// ==========================================================================

	class RenameAction extends AbstractAction
	{
		public void actionPerformed(ActionEvent e)
		{
			TextPadActions.this.myTextPad.myLST.getFileList().renameSomeFiles(); 
		}
	}

	// ==========================================================================
	// HELP Menu
	// ==========================================================================

	JMenu getHelpMenu()
	{
		//JMenu acceleratorsMenu = ActionHelpers.makeMenu("accelerators"); //$NON-NLS-1$ //$NON-NLS-2$
		//acceleratorsMenu.add(makeMenuItem("accelerators", "focus")); //$NON-NLS-1$ //$NON-NLS-2$

		JMenu menu = ActionHelpers.makeMenu("help"); //$NON-NLS-1$
		menu.add(makeMenuItem("help", "help")); //$NON-NLS-1$ //$NON-NLS-2$
		menu.add(makeMenuItem("help", "about")); //$NON-NLS-1$ //$NON-NLS-2$
		menu.add(makeMenuItem("help", "license")); //$NON-NLS-1$ //$NON-NLS-2$
		menu.add(makeMenuItem("help", "info")); //$NON-NLS-1$ //$NON-NLS-2$
		return menu;
	}

	class HelpAction extends AbstractAction
	{
		public void actionPerformed(ActionEvent e)
		{
			boolean showedDesktopDialog = false;
	      try
	      {
	      	if (AppStarter.isJava6Enabled())
	      	{
	      		showedDesktopDialog = AppUtils.helpToBrowser(TextPadActions.this.myTextPad);
	      	}
	      }
	      catch(NoClassDefFoundError ex)
	      {
	      	// java 4
	   		JOptionPane.showMessageDialog(TextPadActions.this.myTextPad, Jibs.getString("SortScreen.10"), //$NON-NLS-1$
	   				Jibs.getString("SortScreen.51"), JOptionPane.INFORMATION_MESSAGE); //$NON-NLS-1$
	      }
	      if (!showedDesktopDialog)
	      {
	     		JOptionPane.showMessageDialog(TextPadActions.this.myTextPad, Jibs.getString("SortScreen.10"), //$NON-NLS-1$
	   				Jibs.getString("SortScreen.51"), JOptionPane.INFORMATION_MESSAGE); //$NON-NLS-1$      	
	      }
		}
	}

	class AboutAction extends AbstractAction
	{
		public void actionPerformed(ActionEvent e)
		{
			new AboutBox(TextPadActions.this.myTextPad);  // Info and About could be more generic...  Slightly...
		}
	}

	class InfoAction extends AbstractAction
	{
		public void actionPerformed(ActionEvent e)
		{
			System.out.println("Show Info not yet available.");
			new Info(TextPadActions.this.myTextPad, TextPadActions.this.myTextPad);  
		}
	}

	class LicenseAction extends AbstractAction
	{
		public void actionPerformed(ActionEvent e)
		{
			new LicenseBox(TextPadActions.this.myTextPad);
		}
	}
}
