/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.jibs.textPad.rankPad;

import java.awt.Dimension;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.*;

/**
 * The Ranked List Of Files
 */
public class DirectoryList extends javax.swing.JList implements ChangeListener, ListSelectionListener
{
	RankPad rankPad;
	DefaultListModel listModel = new DefaultListModel();
	boolean iAmAdjustingIndex = false;
	
	// ==========================================================================
	// Constructor
	// ==========================================================================
	public DirectoryList(RankPad rp)
	{
		super();
		this.rankPad = rp;		
		super.setModel(this.listModel);
		super.setMinimumSize(new Dimension(100, 100));
		super.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		this.rankPad.rankAndFile.addChangeListener(this);
		super.addListSelectionListener(this);
	}
	
	public void stateChanged(ChangeEvent e)
	{
		if (this.rankPad.rankAndFile.getSelectedIndex() == 1)
		{
			this.listModel.removeAllElements();
			File file = this.rankPad.rankList.getSelectedFile();
			if (file == null) { return; }
			File directory = file.getParentFile();
			if (directory == null || !directory.exists()) { return; }
			File[] files = directory.listFiles();
			for (File aFile : files)
			{
				this.listModel.addElement(new RankFileDL(aFile));
			}

			int index = this.listModel.indexOf(new RankFile(file));
			if (index > -1)
			{
				this.iAmAdjustingIndex = true;
				setSelectedIndex(index);
				this.iAmAdjustingIndex = false;
				ensureIndexIsVisible(index);
				this.rankPad.myStatusCount.setText((index + 1) + " of " + this.listModel.size() + " "); //$NON-NLS-1$
			}
		}
	}
	
	public void valueChanged(ListSelectionEvent e) 
	{
		if (this.iAmAdjustingIndex)
		{
			return;
		}
		if (e!= null && e.getValueIsAdjusting())
		{
			return;
		}
		if (!this.rankPad.isVisible())
		{
			// Setting text in JTextPane before showing causes random locks on startup.
			return;
		}
		if (getModel().getSize() == 0)
		{
			return;
		}
		int index = getSelectedIndex();
		if (index < 0)
		{
			return;
		}
		//System.out.println("List changed: " + index);
		File ez = ((RankFile)getSelectedValue()).getFile();
		this.rankPad.showFile(ez, 0);
		this.rankPad.myStatusCount.setText((index + 1) + " of " + this.listModel.size() + " "); //$NON-NLS-1$
	}

 	/**
	 * Override so as to not make too wide.
	 */
	@Override
	public Dimension getPreferredSize()
	{
		Dimension oldSize = super.getPreferredSize();
		return new Dimension(100, (int) oldSize.getHeight());
	}

	public File getSelectedFile()
	{
		RankFile rf = (RankFile)super.getSelectedValue();
		if (rf == null)
		{
			return null;
		}
		return rf.getFile();
	}
	
	class RankFileDL extends RankFile
	{
		RankFileDL(File file)
		{
			super(file);
		}
		
		RankFileDL(String[] tokens, int index)
		{
			super(tokens, index);
		}

		@Override
		public String toString()
		{
			return this.getFile().getName();
		}
	}
}
