package org.gerhardb.jibs.textPad.rankPad;

import java.io.*;
import java.text.DecimalFormat;


class RankFile// extends File
{
	private String[] myTokens;
	private File myFile;
	int myIndex;
	int myRank;
		
	RankFile(File file)
	{
		this.myFile = file;
	}
	
	RankFile(String[] tokens, int index)
	{
		this.myFile = new File(tokens[0]);
		this.myTokens = tokens;
		this.myIndex = index;
		try
		{
			this.myRank = Integer.parseInt(this.myTokens[2]);
		}
		catch(Exception ex)
		{
			// we don't care
		}
	}
	
	File getFile()
	{
		return this.myFile;
	}
	
	void setFile(File file)
	{
		this.myFile = file;
		if (file != null)
		{
			this.myTokens[0] = file.getAbsolutePath();
		}
		else
		{
			this.myTokens[0] = "";
		}
	}
	
	String toLine()
	{
		StringBuffer buff = new StringBuffer(100);
		for(int i=0; i<this.myTokens.length; i++)
		{
			if (i>0)
			{
				buff.append(",");
			}
			buff.append(this.myTokens[i]);
		}
		return buff.toString();
	}
	
	@Override
	public int hashCode()
	{
		return this.myFile.hashCode();
	}
	
	@Override
	public boolean equals(Object o)
	{
		if (o instanceof RankFile)
		{
			RankFile ez = (RankFile)o;
			if (this.myFile.equals(ez.myFile))
			{
				return true;
			}
		}
		return false;
	}
	
	@Override
	public String toString()
	{
		DecimalFormat format = new DecimalFormat("#,##0");
		//int size = RankPanel.this.listModel.size();
		return format.format(this.myIndex) + "  " + format.format(this.myRank) + "  " + this.myFile.getName();
	}
}
